<?php
/******************************************************************************
** codebase.php
*  Coppermine 1.6.x Plugin - showuseragent. Created by KF to show HTTP useragent string. Used when debugging access problems
*  Version 1.0
*  @since  1.6.26
******************************************************************************/

// Make sure that this file can't be accessed directly, but only from within the Coppermine user interface
if (!defined('IN_COPPERMINE')) {
    die('Not in Coppermine...');
}

// Define plugin actions here
$thisplugin->add_action('plugin_install', 'showuseragent_install');
$thisplugin->add_action('plugin_uninstall', 'showuseragent_uninstall');
//$thisplugin->add_action('page_start', 'showuseragent_start');

// Define plugin filters here
$thisplugin->add_filter('page_meta', 'showuseragent_run');      // Choose this hook to be sure that USER_ID has been populated

function showuseragent_start($html) {
    include_once('include/logger.kf.inc.php');
//    global $CPG_PHP_SELF;
//    if ($CPG_PHP_SELF == "editpics.php") {  // As the page_html plugin hook is called in multiple places, only run when we need it - in editpics.php
//        $text_to_find = '<!-- individual file start -->';     //Search for this text which begins every repeat group of file information
//        $text_to_add = '<tr><td colspan="3"><hr></td></tr>' . $text_to_find;    //Add this text to the front of it - a row & cell containing horizontal rule - and replace
//        $html = str_replace($text_to_find, $text_to_add, $html);
//    }
    
//    $useragent = $superCage->server->getRaw('HTTP_USER_AGENT');
    $superCage = Inspekt::makeSuperCage();
    $useragent = $superCage->server->getRaw('HTTP_USER_AGENT');
    $text2write = "Useragent string = " . $useragent;
    log_writekf($text2write, CPG_GLOBAL_LOG);
    return $html;
}


function showuseragent_run(&$html) {

    global $lang_plugin_showuseragent, $CPG_PHP_SELF;
    include_once('include/logger.kf.inc.php');
    

    $superCage = Inspekt::makeSuperCage();

    $useragent = $superCage->server->getRaw('HTTP_USER_AGENT');

    $user_id_def = defined('USER_ID');
    if ($user_id_def) {
        $useridtxt = $lang_plugin_showuseragent['user_id'] . USER_ID;
    } else {
        $useridtxt = $lang_plugin_showuseragent['user_id_not_def'];
    }

    $text2write = $lang_plugin_showuseragent['msg_start'] . $lang_plugin_showuseragent['called_from'] . $CPG_PHP_SELF . "; " . $useridtxt . "; " . $lang_plugin_showuseragent['ua_intro'] . '"' . $useragent . '"';
    log_write($text2write, CPG_GLOBAL_LOG);
    return $html;
}

function showuseragent_install() {
    return true;
}

function showuseragent_uninstall() {
    return true;
}

