<?php
/******************************************************************************
** codebase.php
*  Coppermine 1.6.x Plugin - stream. Created by KF for Photostream style thumbnail display 
*                   Updated May 2024 to improve the way data is altered when displaying the full size image and prevent
*                   potential clash with other plugins
*  Version 1.1.2    Added feature to display page information & navigation above the stream. Also increase max stream size from 100 to 1000.
*          1.1.3    Bug fixes involving incorrect display of meta-albums in certain circumstances
* @since  1.6.22
******************************************************************************/


// Make sure that this file can't be accessed directly, but only from within the Coppermine user interface
if (!defined('IN_COPPERMINE')) {
    die('Not in Coppermine...');
}

// Define plugin actions here
$thisplugin->add_action('plugin_install', 'stream_install');
$thisplugin->add_action('plugin_uninstall', 'stream_uninstall');
$thisplugin->add_action('plugin_cleanup', 'stream_cleanup');
$thisplugin->add_action('post_breadcrumb', 'stream_run');
 
// Define plugin filters here
$thisplugin->add_filter('theme_img_navbar', 'stream_return');
$thisplugin->add_filter('page_meta', 'stream_css');
$thisplugin->add_filter('theme_thumbnails_title', 'stream_title_grid_buttons');
$thisplugin->add_filter('theme_thumbnails_header', 'stream_separate_buttons');
$thisplugin->add_filter('picture_url', 'stream_amend_image_data');


// Define the plugin's functions here

function stream_run() {
    global $CPG_PHP_SELF, $superCage, $CONFIG, $USER_DATA, $CURRENT_ALBUM_DATA, $CURRENT_ALBUM_KEYWORD, $FORBIDDEN_SET_DATA;
    if ($CPG_PHP_SELF == "thumbnails.php") {  // As the post_breadcrumb plugin hook is called in multiple places, only run main part in thumbnail display
        include 'display_stream.inc.php';
        $user = $USER_DATA['user_id'];
        $display_tabs = true;   // Always display tabs
        $display_stream = false; // Display a standard thumbnail grid
        $url_thumb_mode ='';
        if ($superCage->get->keyExists('thumb_mode')) {  // Whatever thumb_mode is passed in on URL overrides other settings. If it's grid drop out
            if ($superCage->get->testAlpha('thumb_mode')) {
        	    $url_thumb_mode = $superCage->get->getAlpha('thumb_mode');
                if (($url_thumb_mode == 'grid') || ($url_thumb_mode == 'stream')) {
                    // If thumb_mode passed in on URL and different to existing user preference, update it provided they are logged in 
                    if ($user > 0) {
                        $userdata = cpg_db_fetch_assoc(cpg_db_query("SELECT `plugin_stream` FROM {$CONFIG['TABLE_USERS']} WHERE user_id = {$user}"));
                        if ($userdata['plugin_stream'] <> $url_thumb_mode) {
                            $plugin_stream_value = ($url_thumb_mode == 'stream') ? 1 : 0;
                            cpg_db_query("UPDATE {$CONFIG['TABLE_USERS']} SET `plugin_stream` = '{$plugin_stream_value}' WHERE user_id = {$user}");
                        }
                    }
                    $display_stream = ($url_thumb_mode == 'stream');
                }
            }
        }
        if (($url_thumb_mode != "grid") && (!$display_stream)) {     // Look for other reasons to display a stream
            if ($user == 0) {    // If user is not logged in
                $display_stream = ($CONFIG['stream_default_choice'] == "1");  // Is stream the default choice ?
            } else {  // User is logged in so check whether they've already chosen their personal default. If not, use "all user" default
                $userdata = cpg_db_fetch_assoc(cpg_db_query("SELECT `plugin_stream` FROM {$CONFIG['TABLE_USERS']} WHERE user_id = {$user}"));
                // Display stream if (user hasn't chosen yet or users aren't allowed to choose) AND stream is the configured default
                $display_stream = ((is_null($userdata['plugin_stream']) || ($CONFIG['stream_user_choice'] == 0))&& ($CONFIG['stream_default_choice'] == "1"))  
                    || ($userdata['plugin_stream'] == "1");    // OR user has previously chosen stream mode
            }
        }
        if ($display_stream) {
            if ($superCage->get->keyExists('album')) {
                if ($superCage->get->testAlpha('album')) {
                    $album = $superCage->get->getAlpha('album');
                } else {
                    $album = $superCage->get->getInt('album');
                }
            } 
            if ($superCage->get->keyExists('cat')) {
                if ($superCage->get->testAlpha('cat')) {
                    $cat = $superCage->get->getAlpha('cat');
                } else {
                    $cat = $superCage->get->getInt('cat');
                }
            } else {
                $cat = (is_numeric($album) ? -$album : 0);
            }
            /****  Code below lifted unaltered from thumbnails.php to deal with password protected albums only ***/
            $valid = false; //flag to test whether the album is validated.
            if ($CONFIG['allow_private_albums'] == 0 || !in_array($album, $FORBIDDEN_SET_DATA)) {
                $valid = true;
            } elseif ($superCage->post->keyExists('validate_album')) {
                $password = md5($superCage->post->getEscaped('password'));
                $sql = "SELECT aid FROM {$CONFIG['TABLE_ALBUMS']} WHERE alb_password = '$password' AND aid = $album";
                $result = cpg_db_query($sql);
                if ($result->numRows()) {
                    $albpw = $superCage->cookie->getEscaped($CONFIG['cookie_name'] . '_albpw');
                    if (!empty($albpw)) {
                        $albpw = unserialize($albpw);
                    }
                    $albpw[$album] = $password;
                    $alb_cookie_str = serialize($albpw);

                    setcookie($CONFIG['cookie_name'] . "_albpw", $alb_cookie_str);
                    get_private_album_set($album);
                    $valid = true;
                } else {
                    // Invalid password
                    $valid = false;
                }
            } else {
                $sql = "SELECT aid FROM {$CONFIG['TABLE_ALBUMS']} WHERE aid = $album AND alb_password != ''";
                $result = cpg_db_query($sql);
                if ($result->numRows()) {
                    // This album has a password.
                    // Check whether the cookie is set for the current albums password
                    $albpw = $superCage->cookie->getEscaped($CONFIG['cookie_name'] . '_albpw');
                    if (!empty($albpw)) {
                        $alb_pw = unserialize($albpw);
                        // Check whether the alubm id in the cookie is same as that of the album id send by get
                        if (isset($alb_pw[$album])) {
                            $sql = "SELECT aid FROM {$CONFIG['TABLE_ALBUMS']} WHERE alb_password = '{$alb_pw[$album]}' AND aid = $album";
                            $result = cpg_db_query($sql);
                            if ($result->numRows()) {
                                $valid = true; //The album password is correct. Show the album details.
                                get_private_album_set();
                            }
                        }
                    }
                } else {
                    // Album with no password. Might be a private or normal album. Just set valid as true.
                    $valid = true;
                }
            }
            /****  End of code block lifted unaltered from thumbnails.php ***/
           if (!$valid) {   // not valid so prompt user for password
                form_albpw();
                pagefooter();
                exit;
            } else {
                $page = $superCage->get->testInt('page') ? max($superCage->get->getInt('page'), 1) : 1;  // Get page number passed in URL
                $stream_thumb_per_page = $CONFIG['stream_num_pics_page'];
                $lower_limit = ($page - 1) * $stream_thumb_per_page;
                if (is_numeric($album)) {
                    $result = cpg_db_query("SELECT COUNT(*) FROM {$CONFIG['TABLE_PICTURES']} WHERE aid='$album'");
                    list($count) = $result->fetchRow(true);
                    $pic_count = $count;            // Count of pictures in the album in the normal way
                    $result = cpg_db_query("SELECT category, title, aid, keyword, description, alb_password_hint FROM {$CONFIG['TABLE_ALBUMS']} WHERE aid = $album");
                    if ($result->numRows() > 0) {
                        $CURRENT_ALBUM_DATA = $result->fetchAssoc();
                        $CURRENT_ALBUM_KEYWORD = $CURRENT_ALBUM_DATA['keyword'];                    
                        $result = cpg_db_query("SELECT COUNT(*) FROM {$CONFIG['TABLE_PICTURES']} WHERE keywords like '%{$CURRENT_ALBUM_KEYWORD}%'");
                        if ($result->numRows() > 0) {
                            list($count) = $result->fetchRow(true);
                            $pic_count_keyword = $count;        // Count of pictures linked into the album using the keyword method
                            $pic_count = $pic_count + $pic_count_keyword;    // Total of pictures actually in the album and those linked via the keyword method
                        }
                    }
                    $upper_limit = min($pic_count, $page * $stream_thumb_per_page);
                } else {
                    $upper_limit = $stream_thumb_per_page;
                }
                $pic_data = get_pic_data($album, $total_thumbs, $album_name, $lower_limit, $upper_limit);
                $total_pages = ceil($total_thumbs / $stream_thumb_per_page);
                $thumbs_to_display = min(count($pic_data),$stream_thumb_per_page);
                display_stream($pic_data, $user, $total_thumbs, $thumbs_to_display, $album_name, $album, $cat, $page, $total_pages, $display_tabs);
                pagefooter();
                exit; 
            }
        } else {
            $stream_return['thumb_mode'] = 'grid';
        }
    } 
}
function stream_amend_image_data($pic_row) {
    global $CONFIG, $CPG_PHP_SELF;
    // The purpose of this code is to display the appropriate large image when intermediate images are used, noting that intermediate images are necessary 
    // for best  performance when this plugin is operating. Intermediate images are recommended to be 350 px high to match the stream height and minimise resizing. 
    // They are used by the stream, resized down where needed, but are too small to be displayed as the main image on the screen created by displayimage.php   
    // Instead, you want the full size image. By fiddling with the parameters here you can fool displayimage.php into thinking that intermediate images are not
    // being used so it will display the full size image rather than the intermediate version. 
    // It is only actioned when displayimage.php is run by the user   
    if ($CPG_PHP_SELF == "displayimage.php") {  // As the init hook is called everywhere, only run this when displaying large image
        if ($pic_row['mode'] == 'normal') {  // If intermediate image is wanted this must be for the large image so change it to use the full size if override chosen
            if ($CONFIG['stream_override_int'] == 1) {
                $pic_row['mode'] = 'fullsize';  // If chosen in the plugin configuration, use the full size image instead of intermediate
                $pic_row['url'] = $CONFIG['fullpath'] . $pic_row['filepath'] . $pic_row['filename'];  // Use the full-size
            }
        }
    }
    return $pic_row;
}

// Use plugin hook to call the stream CSS file 
function stream_css($header_html) {
    global $CPG_PHP_SELF;
    if ($CPG_PHP_SELF == "thumbnails.php") {  // As the page_meta plugin hook is called in multiple places, only run in thumbnail display
        $header_html .= "<link rel=\"stylesheet\" href=\"plugins/stream/stream.css\" type=\"text/css\" />";
    }
    return $header_html;
}

function stream_return($header_html) {
// Modify the button in the large image display (displayimage.php) to return to stream version of thumbnails on right page
    global $superCage, $CONFIG, $USER_DATA, $CURRENT_PIC_DATA;
    $url_thumb_mode ='';
    if ($superCage->get->keyExists('thumb_mode')) {
        if ($superCage->get->testAlpha('thumb_mode')) {
    	    $url_thumb_mode = $superCage->get->getAlpha('thumb_mode');
        }
    }
    if ($superCage->get->keyExists('album')) {    // The function must be called with a valid album id in the URL, otherwise won't get this far
        if ($superCage->get->testAlpha('album')) {
            $album = $superCage->get->getAlpha('album');
        } else {
            $album = $superCage->get->getInt('album');
        }
    } 
    $page = 1;  // Default - return to page 1
    if ($superCage->get->keyExists('return_page')) {    
        if ($superCage->get->testAlpha('return_page')) {
            $page = $superCage->get->getAlpha('return_page');
        } else {
            $page = $superCage->get->getInt('return_page');
        }
    } 
    $thumb_tgt_string = 'thumbnails.php?album=' . $CURRENT_PIC_DATA['aid'] . "&page=" . $page . "&thumb_mode=" . (($url_thumb_mode=='stream') ? 'stream' : 'grid');
    $params = array(
        '{THUMB_TGT}' => $thumb_tgt_string,
    );
    $header_html = template_eval($header_html, $params);
    return $header_html;
}

function stream_separate_buttons($header_html) {
    // Display the buttons on a separate row. This happens either when i) separate buttons are configured or ii) title row buttons are configured and a
    // meta album is being displayed in grid mode because I can't find any way of displaying a meta album with buttons in the title row. Technically this 
    // is because the only suitable plugin hook is 'theme_thumbnails_title' but function theme_display_thumbnails  in themes.inc.php doesn't have this plugin  
    // hook where needed in the code dealing with meta-albums - around line 2882 where it only has the code $title = $album_name 
//    global $CONFIG, $superCage, $stream_master_templates, $lang_plugin_stream;
    global $CONFIG, $superCage, $lang_plugin_stream;
    
    include 'stream_templates.inc.php';
    if ($superCage->get->keyExists('album')) {    // thumbnails.php must be called with a valid album id in the URL, otherwise won't get this far
        if ($CONFIG['stream_user_choice'] > 0 ) { // if users are allowed to choose...
            if ($superCage->get->testAlpha('album')) {
                $album = $superCage->get->getAlpha('album'); 
                $meta_album = true; 
            } else {
                $album = $superCage->get->getInt('album'); 
                $meta_album = false; 
            }
            if ($superCage->get->keyExists('cat')) {
                if ($superCage->get->testAlpha('cat')) {
                    $cat = $superCage->get->getAlpha('cat');
                } else {
                    $cat = $superCage->get->getInt('cat');
                }
            } else {
                $cat = (is_numeric($album) ? -$album : 0);
            }
            $colspan = $CONFIG['thumbcols'];
            $page = $superCage->get->testInt('page') ? max($superCage->get->getInt('page'), 1) : 1;  // Get current page number as passed in URL
            $grid_num_pics_page = $CONFIG['thumbcols'] * $CONFIG['thumbrows'];
            if ($grid_num_pics_page == $CONFIG['stream_num_pics_page']) {
                $stream_page = $page;
            } elseif (($grid_num_pics_page / $CONFIG['stream_num_pics_page']) < 1) {
                $stream_page = 1 + floor($page * $grid_num_pics_page / $CONFIG['stream_num_pics_page']);
            } else {
                $stream_page = 1 + floor(($page - 1) * $grid_num_pics_page / $CONFIG['stream_num_pics_page']);
            }
            $param = array(
                '{ALBUM_ID}'   => $album,
                '{COLSPAN}'    => $colspan,
                '{PAGE}'       => $stream_page,
                '{CAT}'        => $cat,
                '{GRID}'       => $lang_plugin_stream['grid'],
                '{STREAM}'     => $lang_plugin_stream['stream'],
                '{BUTTON_TITLE}' => $lang_plugin_stream['button_title'],
            );
           if ((($CONFIG['stream_buttons_separate'] == 0) && $meta_album) || ($CONFIG['stream_buttons_separate'] == 1)){
                $stream_selector = template_extract_block($stream_master_templates, 'stream_selector_grid_mode_separate');  // Get the radio buttons and text from template
                $header_html .= template_eval($stream_selector, $param); // Fill in the album id and add to HTML passed in
            }
        }
    } 
    return($header_html);
}

function stream_buttons_stream_mode($grid_page) {
    // Display the buttons on a separate row in stream mode only. 
    global $CONFIG, $superCage, $lang_plugin_stream;
    
    include 'stream_templates.inc.php';
    $stream_selector = template_extract_block($stream_master_templates, 'stream_selector_stream_mode_separate');  // Get the radio buttons and text from template
    if ($superCage->get->keyExists('album')) {    // The function must be called with a valid album id in the URL, otherwise won't get this far
        if ($superCage->get->testAlpha('album')) {
            $album = $superCage->get->getAlpha('album'); 
        } else {
            $album = $superCage->get->getInt('album');
        }
        if ($superCage->get->keyExists('cat')) {
            if ($superCage->get->testAlpha('cat')) {
                $cat = $superCage->get->getAlpha('cat');
            } else {
                $cat = $superCage->get->getInt('cat');
            }
        } else {
            $cat = (is_numeric($album) ? -$album : 0);
        }
        $colspan = $CONFIG['thumbcols'];
        $param = array(
            '{ALBUM_ID}'   => $album,
            '{COLSPAN}'    => $colspan,
            '{PAGE}'       => $grid_page,
            '{CAT}'        => $cat,
            '{GRID}'       => $lang_plugin_stream['grid'],
            '{STREAM}'     => $lang_plugin_stream['stream'],
            '{BUTTON_TITLE}' => $lang_plugin_stream['button_title'],
   );
        $header_html = template_eval($stream_selector, $param); // Fill in the album id and add to HTML passed in
    } 
    return($header_html);
}


function stream_title_grid_buttons($title_html) {
// When in grid mode (only) display the selector buttons. Either update the album title row to add the table containing the stream radio buttons
// or display them on a separate line
    global $CONFIG, $USER_DATA, $CURRENT_ALBUM_DATA, $superCage, $template_thumb_view_title_row, $lang_plugin_stream;
    
    include 'stream_templates.inc.php';
    if ($CONFIG['stream_buttons_separate'] == 0) {     // Only add selector buttons to title line when they've been chosen
        $user = $USER_DATA['user_id'];
        if ((($user == 0 ) && ($CONFIG['stream_user_choice'] == 2)) || (($user <> 0) && ($CONFIG['stream_user_choice'] > 0))) {       // If user allowed to choose the mode
            if ($CONFIG['stream_buttons_separate'] == 0) {  // Only proceed here if we're adding to the title line
                $stream_selector = template_extract_block($stream_master_templates, 'stream_selector_grid_mode');  // Get the radio buttons and text from template
                // Redefine the template by adding in a new block of HTML. Hopefully this will still be compatible with other plugins, noting that the template has a </td> at beginning and <td> at end
                $template_thumb_view_title_row = substr_replace($template_thumb_view_title_row, $stream_selector, strpos($template_thumb_view_title_row, '</td>'), strlen('</td>'));
                // want to add td width attribute so replace the existing class attribute with width and class attributes combined
                $template_thumb_view_title_row = substr_replace($template_thumb_view_title_row, ('width="40%"' . ' class="statlink"'), strpos($template_thumb_view_title_row, 'class="statlink"'), strlen('class="statlink"'));
                $page = $superCage->get->testInt('page') ? max($superCage->get->getInt('page'), 1) : 1;  // Get page number passed in URL, default to 1
                if ($superCage->get->keyExists('album')) {    // The function must be called with a valid album id in the URL, otherwise won't get this far
                    if ($superCage->get->testAlpha('album')) {
                        $album = $superCage->get->getAlpha('album'); 
                    } else {
                         $album = $superCage->get->getInt('album'); 
                    }
                }
                if ($superCage->get->keyExists('cat')) {
                    if ($superCage->get->testAlpha('cat')) {
                        $cat = $superCage->get->getAlpha('cat');
                    } else {
                        $cat = $superCage->get->getInt('cat');
                    }
                } else {
                    $cat = (is_numeric($album) ? -$album : 0);
                }
                $grid_num_pics_page = $CONFIG['thumbcols'] * $CONFIG['thumbrows'];
                if ($grid_num_pics_page == $CONFIG['stream_num_pics_page']) {
                    $stream_page = $page;
                } else {
                    $stream_page = ceil((1 + (($page - 1) * $grid_num_pics_page))/ $CONFIG['stream_num_pics_page']);
                }
                $param = array(
                    '{ALBUM_ID}'   => $album,
                    '{PAGE}'       => $stream_page,  
                    '{CAT}'        => $cat,
                    '{GRID}'       => $lang_plugin_stream['grid'],
                    '{STREAM}'     => $lang_plugin_stream['stream'],
                    '{BUTTON_TITLE}' => $lang_plugin_stream['button_title'],
                        );
                $template_thumb_view_title_row = template_eval($template_thumb_view_title_row, $param); // Fill in the album id
            } 
        }
    }
    return($title_html);
}  

function stream_install() {
    global $CONFIG, $lang_plugin_stream, $stream_default; 

    cpg_db_query("INSERT IGNORE INTO {$CONFIG['TABLE_CONFIG']} (`name`, `value`) 
                 VALUES ('stream_width', {$stream_default['width']}),
                ('stream_min_height', {$stream_default['min_height']}),
                ('stream_max_height', {$stream_default['max_height']}),
                ('stream_num_pics_page', {$stream_default['num_pics_page']}),
                ('stream_divider', {$stream_default['divider']}), 
                ('stream_user_choice', {$stream_default['user_choice']}), 
                ('stream_default_choice', {$stream_default['default_choice']}),
                ('stream_buttons_separate', {$stream_default['stream_buttons_separate']}),
                ('stream_override_int', {$stream_default['stream_override_int']}),
                ('stream_page_nav', {$stream_default['stream_disp_page']})
                ");
    // Test to see if database meta-data exists for the column (plugin_stream) that needs to be added for install. If not, add it
    $sql = "select ordinal_position from INFORMATION_SCHEMA.COLUMNS where table_name='{$CONFIG['TABLE_USERS']}' and table_schema = '{$CONFIG['dbname']}' and column_name='plugin_stream'";
    $result=cpg_db_query($sql);
//  Find how many rows there are. If it's one, the column already exists, if zero it doesn't so add it
    $num_rows = cpg_db_num_rows($result);
    if ($num_rows == 0) {
        cpg_db_query("ALTER TABLE {$CONFIG['TABLE_USERS']} ADD `plugin_stream` TINYINT(1) null");
    }
    return true;
}

function stream_uninstall() {
    global $CONFIG, $lang_plugin_stream, $lang_errors;
    $superCage = Inspekt::makeSuperCage();
    if (!checkFormToken()) {
        cpg_die(ERROR, $lang_errors['invalid_form_token'], __FILE__, __LINE__);
    }
	if ($superCage->post->keyExists('stream_submit') && $superCage->post->keyExists('stream_uninstall_type')) {
		if ($superCage->post->getInt('stream_uninstall_type') == 1) {
            // Delete the plugin config records
             cpg_db_query("DELETE FROM {$CONFIG['TABLE_CONFIG']} WHERE name IN ( 
                        'stream_width', 
                        'stream_min_height', 
                        'stream_max_height', 
                        'stream_num_pics_page', 
                        'stream_divider',
                        'stream_user_choice', 
                        'stream_default_choice',
                        'stream_buttons_separate',
                        'stream_override_int',
                        'stream_page_nav'
                        )");
            // Test to see if database meta-data exists for the column (plugin_stream) that needs to be deleted for uninstall. If it exists, delete it
            $sql = "select ordinal_position from INFORMATION_SCHEMA.COLUMNS where table_name='{$CONFIG['TABLE_USERS']}' and table_schema = '{$CONFIG['dbname']}' and column_name='plugin_stream'";
            $result=cpg_db_query($sql);
            $num_rows = cpg_db_num_rows($result);
            //  Find how many rows there are. If it's one, the column already exists, if zero it doesn't    
            if ($num_rows <> 0) {
                cpg_db_query("ALTER TABLE {$CONFIG['TABLE_USERS']} DROP column `plugin_stream`");
            }
        }
        return true;
    } else {
        return 1;
    }
}

function stream_cleanup ()  {
	global $lang_common, $superCage, $lang_plugin_stream;

	echo '<form name="cpgform" id="cpgform" action="'.$superCage->server->getEscaped('REQUEST_URI').'" method="post">';
	echo <<<EOT
	<br />{$lang_plugin_stream['uninstall_type']}<br />
	<input type="radio" name="stream_uninstall_type" id="stream_full" value="1" checked="checked" /> 
        <label for="stream_full">{$lang_plugin_stream['uninstall_full']}</label><br />
	<input type="radio" name="stream_uninstall_type" id="stream_partial" value="2"  /> 
        <label for="stream_partial">{$lang_plugin_stream['uninstall_partial']}</label><br />
	<br /><input type="submit" name="stream_submit" value="{$lang_common['continue']}" class="button" style="padding-right:5px;padding-left:5px" />
	</form>
EOT;
}


