<?php
/******************************************************************************
** config.php
*  Coppermine 1.6.x Plugin - stream. Created by KF for Photostream style thumbnail display 
*  Version 1.1.2 June 2024 Max number of pics per page increased from 100 to 1000 as requested.
*                   Allow page navigation to be included above the stream
* @since  1.6.22
******************************************************************************/

require('configuration.php');       // Include this to pick up default for stream_page_nav
// create Inspekt supercage
$superCage = Inspekt::makeSuperCage();

// Make sure that this file can't be accessed directly, but only from within the Coppermine user interface
if (!defined('IN_COPPERMINE')) {
    die('Not in Coppermine...');
}

if (!GALLERY_ADMIN_MODE) {
    cpg_die(ERROR, $lang_errors['access_denied'], __FILE__, __LINE__);
}

// get sanitized POST parameters
if ($superCage->post->keyExists('submit')) {
  // Define the sanitization patterns
  $sanitization_array = array(
      'stream_width' =>             array('type' => 'int', 'min' => '1000', 'max' => '1800'),
      'stream_min_height' =>        array('type' => 'int', 'min' => '100', 'max' => '400'),
      'stream_max_height' =>        array('type' => 'int', 'min' => '125', 'max' => '500'),
      'stream_num_pics_page' =>     array('type' => 'int', 'min' => '12', 'max' => '1000'),
      'stream_divider' =>           array('type' => 'int', 'min' => '0', 'max' => '10'),
      'stream_user_choice' =>       array('type' => 'checkbox', 'min' => '0', 'max' => '2'),
      'stream_default_choice' =>    array('type' => 'checkbox', 'min' => '0', 'max' => '1'),
      'stream_buttons_separate' =>  array('type' => 'checkbox', 'min' => '0', 'max' => '1'),
      'stream_page_nav' =>          array('type' => 'checkbox', 'min' => '0', 'max' => '1'),
      'stream_override_int' =>      array('type' => 'checkbox', 'min' => '0', 'max' => '1')
  );
  if (!isset($CONFIG['stream_page_nav'])) {      // Add in a fudge for anyone upgrading to plugin 1.1.2 as this parameter won't exist in database so add it
      $CONFIG['stream_page_nav'] = 0;
       cpg_db_query("INSERT IGNORE INTO {$CONFIG['TABLE_CONFIG']} (`name`, `value`) 
                 VALUES ('stream_page_nav', {$stream_default['stream_disp_page']})
                ");
  }
  $config_changes_counter = 0;
  $stream_height_bad = false;
  foreach ($sanitization_array as $san_key => $san_value) {
      if (isset($CONFIG[$san_key]) == TRUE) { // only loop if config value is set --- start
          if ($san_value['type'] == 'checkbox') { // type is checkbox --- start
            if ($superCage->post->getInt($san_key) <= $san_value['max'] && $superCage->post->getInt($san_key) >= $san_value['min'] && $superCage->post->getInt($san_key) != $CONFIG[$san_key]) {
                $CONFIG[$san_key] = $superCage->post->getInt($san_key);
                cpg_db_query("UPDATE {$CONFIG['TABLE_CONFIG']} SET value='{$CONFIG[$san_key]}' WHERE name='$san_key'");
                $config_changes_counter++;
            } elseif($superCage->post->keyExists($san_key) != TRUE && $CONFIG[$san_key] != '0') {
                $CONFIG[$san_key] = 0;
                cpg_db_query("UPDATE {$CONFIG['TABLE_CONFIG']} SET value='{$CONFIG[$san_key]}' WHERE name='$san_key'");
                $config_changes_counter++;
            }
          } // type is checkbox --- end
          if ($san_value['type'] == 'int') { // type is integer --- start
              if ($superCage->post->getInt($san_key) <= $san_value['max'] && $superCage->post->getInt($san_key) >= $san_value['min'] && $superCage->post->getInt($san_key) != $CONFIG[$san_key]) {
                 if ($san_key == 'stream_max_height') {
                      $stream_height_bad =  ($superCage->post->getInt('stream_max_height') < $superCage->post->getInt('stream_min_height') * 1.25);
                  }
                  if (!$stream_height_bad) {
                      $CONFIG[$san_key] = $superCage->post->getInt($san_key);
                      cpg_db_query("UPDATE {$CONFIG['TABLE_CONFIG']} SET value='{$CONFIG[$san_key]}' WHERE name='$san_key'");
                      $config_changes_counter++;
                  }
              }
          } // type is integer --- end
          if ($san_value['type'] == 'raw') { // type is raw --- start
              if (isset($san_value['regex']) == TRUE && preg_match($san_value['regex'], $superCage->post->getRaw($san_key)) && $superCage->post->getRaw($san_key) != $CONFIG[$san_key]) {
                  $CONFIG[$san_key] = $superCage->post->getRaw($san_key);
                  if ($superCage->post->getRaw($san_key) == 'none') {
                    $CONFIG[$san_key] = '';
                  }
                  cpg_db_query("UPDATE {$CONFIG['TABLE_CONFIG']} SET value='{$CONFIG[$san_key]}' WHERE name='$san_key'");
                  $config_changes_counter++;
              }
          } // type is raw --- end
          if ($san_value['type'] == 'array') { // type is array --- start              
          $evaluate_value = $superCage->post->getRaw($san_key);
              if (is_array($evaluate_value) && isset($san_value['regex']) == TRUE && isset($san_value['delimiter']) == TRUE) {
                  $temp = '';
                  for ($i = 0; $i <= count($evaluate_value); $i++) {
                      if (preg_match($san_value['regex'], $evaluate_value[$i])) {
                          $temp .= $evaluate_value[$i] . $san_value['delimiter'];
                      }
                  }
                  unset($evaluate_value);
                  $evaluate_value = rtrim($temp, $san_value['delimiter']);
                  unset($temp);
              }
              if ($evaluate_value != $CONFIG[$san_key]) {
                  $CONFIG[$san_key] = $evaluate_value;
                  cpg_db_query("UPDATE {$CONFIG['TABLE_CONFIG']} SET value='{$CONFIG[$san_key]}' WHERE name='$san_key'");
                  $config_changes_counter++;
              }
          } // type is array --- end
      } // only loop if config value is set --- end
  }
}


// display config page
$submit_icon = cpg_fetch_icon('ok', 1);

// Set the option output stuff 

switch ($CONFIG['stream_user_choice']) {
    case '0':
        $option_output['stream_user_choice'][0] = 'checked="checked"';
        $option_output['stream_user_choice'][1] = '';
        $option_output['stream_user_choice'][2] = '';
        break;
    case '1':
        $option_output['stream_user_choice'][0] = '';
        $option_output['stream_user_choice'][1] = 'checked="checked"';
        $option_output['stream_user_choice'][2] = '';
        break;
    case '2':
        $option_output['stream_user_choice'][0] = '';
        $option_output['stream_user_choice'][1] = '';
        $option_output['stream_user_choice'][2] = 'checked="checked"';
        break;
}
if ($CONFIG['stream_default_choice'] == '1') {
    $option_output['stream_default_choice'][0] = '';
    $option_output['stream_default_choice'][1] = 'checked="checked"';
} else {
    $option_output['stream_default_choice'][0] = 'checked="checked"';
    $option_output['stream_default_choice'][1] = '';
}
$option_output['stream_width'] = $CONFIG['stream_width'];
$option_output['stream_min_height'] = $CONFIG['stream_min_height'];
$option_output['stream_max_height'] = $CONFIG['stream_max_height'];
$option_output['stream_num_pics_page'] = $CONFIG['stream_num_pics_page'];
$option_output['stream_divider'] = $CONFIG['stream_divider'];
if ($CONFIG['stream_buttons_separate'] == '1') {
    $option_output['stream_buttons_separate'][0] = '';
    $option_output['stream_buttons_separate'][1] = 'checked="checked"';
} else {
    $option_output['stream_buttons_separate'][0] = 'checked="checked"';
    $option_output['stream_buttons_separate'][1] = '';
}
if ($CONFIG['stream_page_nav'] == '1') {
    $option_output['stream_page_nav'][0] = '';
    $option_output['stream_page_nav'][1] = 'checked="checked"';
} else {
    $option_output['stream_page_nav'][0] = 'checked="checked"';
    $option_output['stream_page_nav'][1] = '';
}
if ($CONFIG['stream_override_int'] == '1') {
    $option_output['stream_override_int'][0] = '';
    $option_output['stream_override_int'][1] = 'checked="checked"';
} else {
    $option_output['stream_override_int'][0] = 'checked="checked"';
    $option_output['stream_override_int'][1] = '';
}
if ($superCage->post->keyExists('submit')) {
    if ($stream_height_bad) {
            msg_box('', $lang_plugin_stream['stream_height_bad'], '', '', 'error');
    } else {
        if ($config_changes_counter > 0) {
            msg_box('', $lang_plugin_stream['update_success'], '', '', 'success');
        } else {
            msg_box('', $lang_plugin_stream['no_changes'], '', '', 'info');
        }
    }
}

// Identify the plugin being configured
starttable('100%', sprintf($lang_plugin_stream['configure_x'], $lang_plugin_stream['plugin_name']), 3, 'cpg_zebra');

echo <<<EOT
    <!-- insert config option form code start -->
	<tr>
		<td class="tableb" width="45%">
			{$lang_plugin_stream['stream_width']} 
		</td>
		<td class="tableb">
			<input type="text" name="stream_width" id="stream_width" style="width:4em" min="1000" max="2000" value="{$CONFIG['stream_width']}" {$option_output['stream_width']}" />
		</td>
	</tr>
    <tr>
		<td class="tableb">
			{$lang_plugin_stream['stream_min_height']} 
		</td>
		<td class="tableb">
			<input type="text" name="stream_min_height" style="width:3em" min="100" max="400" value="{$CONFIG['stream_min_height']}" {$option_output['stream_min_height']} />
		</td>
	</tr>
	<tr>
		<td class="tableb">
			{$lang_plugin_stream['stream_max_height']} 
		</td>
		<td class="tableb">
			<input type="text" name="stream_max_height" style="width:3em" min="125" max="500" value="{$CONFIG['stream_max_height']}" {$option_output['stream_max_height']} />
		</td>
	</tr>
	<tr>
		<td class="tableb">
			{$lang_plugin_stream['stream_num_pics_page']} 
		</td>
		<td class="tableb">
			<input type="text" name="stream_num_pics_page"  style="width:3em" min="12" max="100" value="{$CONFIG['stream_num_pics_page']}" {$option_output['stream_num_pics_page']} />
		</td>
	</tr>
	<tr>
		<td class="tableb">
			{$lang_plugin_stream['stream_divider']} 
		</td>
		<td class="tableb">
			<input type="text" name="stream_divider"  style="width:3em" min="0" max="6" value="{$CONFIG['stream_divider']}" {$option_output['stream_divider']} />
		</td>
	</tr>
    <tr>
		<td class="tableb">
			{$lang_plugin_stream['stream_user_choice']} 
		</td>
        <td class="tableb">
            <input type="radio" name="stream_user_choice" id="stream_user_choice_0" class="radio" value="0" {$option_output['stream_user_choice'][0]}/>
            <label for="stream_user_choice_0" class="clickable_option">{$lang_plugin_stream['user_choice_none']}</label>
        <br>
            <input type="radio" name="stream_user_choice" id="stream_user_choice_1" class="radio" value="1" {$option_output['stream_user_choice'][1]}/>
            <label for="stream_user_choice_1" class="clickable_option">{$lang_plugin_stream['user_choice_logged_in']}</label>
        <br>
            <input type="radio" name="stream_user_choice" id="stream_user_choice_2" class="radio" value="2" {$option_output['stream_user_choice'][2]}/>
            <label for="stream_user_choice_2" class="clickable_option">{$lang_plugin_stream['user_choice_all']}</label>
        </td>
   </tr>
    <tr>
		<td class="tableb">
			{$lang_plugin_stream['stream_default_choice']}
		</td>
        <td class="tableb">
            <input type="radio" name="stream_default_choice" id="stream_default_choice_0" class="radio" value="0" {$option_output['stream_default_choice'][0]}/>
            <label for="stream_default_choice_0" class="clickable_option">{$lang_plugin_stream['grid']}</label>
        <br>
            <input type="radio" name="stream_default_choice" id="stream_default_choice_1" class="radio" value="1" {$option_output['stream_default_choice'][1]}/>
            <label for="stream_default_choice_1" class="clickable_option">{$lang_plugin_stream['stream']}</label>
        </td>
    </tr>
    <tr>
		<td class="tableb">
			{$lang_plugin_stream['stream_buttons_separate']}
		</td>
        <td class="tableb">
            <input type="radio" name="stream_buttons_separate" id="stream_buttons_separate_0" class="radio" value="0" {$option_output['stream_buttons_separate'][0]}/>
            <label for="stream_buttons_separate_0" class="clickable_option">{$lang_plugin_stream['stream_title']}</label>
        <br>
            <input type="radio" name="stream_buttons_separate" id="stream_buttons_separate_1" class="radio" value="1" {$option_output['stream_buttons_separate'][1]}/>
            <label for="stream_buttons_separate_1" class="clickable_option">{$lang_plugin_stream['stream_separate']}</label>
        </td>
    </tr>
    <tr>
		<td class="tableb">
			{$lang_plugin_stream['stream_page_nav']}
		</td>
        <td class="tableb">
            <input type="radio" name="stream_page_nav" id="stream_page_nav_0" class="radio" value="0" {$option_output['stream_page_nav'][0]}/>
            <label for="stream_page_nav_0" class="clickable_option">{$lang_common['no']}</label>
        <br>
            <input type="radio" name="stream_page_nav" id="stream_page_nav_1" class="radio" value="1" {$option_output['stream_page_nav'][1]}/>
            <label for="stream_page_nav_1" class="clickable_option">{$lang_common['yes']}</label>
        </td>
    </tr>
    <tr>
		<td class="tableb">
			{$lang_plugin_stream['stream_override_int']}
		</td>
        <td class="tableb">
            <input type="radio" name="stream_override_int" id="stream_override_int_0" class="radio" value="0" {$option_output['stream_override_int'][0]}/>
            <label for="stream_override_int_0" class="clickable_option">{$lang_plugin_stream['stream_override_no']}</label>
        <br>
            <input type="radio" name="stream_override_int" id="stream_override_int_1" class="radio" value="1" {$option_output['stream_override_int'][1]}/>
            <label for="stream_override_int_1" class="clickable_option">{$lang_plugin_stream['stream_override_yes']}</label>
        </td>
    </tr>
    <!-- insert config option form code end -->
    <tr>
        <td></td>
        <td class="tablef" colspan="3">
            <button type="submit" class="button" style="text-align:center" name="submit" value="{$lang_plugin_stream['submit']}">{$submit_icon}{$lang_plugin_stream['submit']}</button>
        </td>
    </tr>
EOT;

endtable();

//EOF
