<?php
/**************************************************
  Coppermine 1.6.x Plugin - stream
  2024-04-07  KF Updated to Version 1.1 to include plugin hook that allows thumbnail parameters to be changed
  2024-06-24  KF Version 1.1.2. Add parameter for default value for display of page information above the stream
  2025-07-30  KF Version 1.1.3. Update version number. Various bugs fixed in other php files
**************************************************/

// Make sure that this file can't be accessed directly, but only from within the Coppermine user interface
if (!defined('IN_COPPERMINE')) {
    die('Not in Coppermine...');
}
global $stream_default;

$name = $lang_plugin_stream['plugin_name'];
$description = $lang_plugin_stream['plugin_description'];
$author = 'KF';
$version = '1.1.3';
$plugin_cpg_version = array('min' => '1.6');
$install_info = $lang_plugin_stream['install_info'];
$extra_info = $lang_plugin_stream['extra_info'];
$config_action = 'config';

$stream_default['width'] = 1350;        // Width of the whole stream across the page
$stream_default['min_height'] = 280;    // Target minimum height of a row in the stream
$stream_default['max_height'] = 350;    // Target maximum height of a row in the stream. Must be at least 25% greater than minimum height
$stream_default['num_pics_page'] = 24;  // Max number of pictures on a stream page
$stream_default['divider'] = 3;         // Width of divider between pictures in the stream
$stream_default['user_choice'] = 1;     // Which users are allowed to choose between stream and standard grid format display
$stream_default['default_choice'] = 1;  // By default the stream display is enabled.
$stream_default['stream_use_full_size'] = 1;  // By default resize full-size pictures for the stream, otherwise use intermediate
$stream_default['stream_buttons_separate'] = 1;  // By default the stream buttons are put on the title line, otherwise on their own line
$stream_default['stream_override_int'] = 0;  // By default when intermediate images are used, display the intermediate image on the image display page. This can be overriden here
$stream_default['stream_disp_page'] = 0;  // Whether to display page information & navigation on a bar above the stream. Default: no




