<?php
/******************************************************************************
** display_stream.inc.php
*  Coppermine 1.6.x Plugin - stream. Created by KF for Photostream style thumbnail display.
*  Updated 11 Sep 2023 to fix bug where the grid/stream selector was displayed when it should not have been 
*  Version 1.01
* @since  1.6.22
******************************************************************************/


function display_stream(&$thumb_list, $user, $total_thumbs, $thumbs_to_display, $album_name, $aid, $cat, $page, $total_pages, $display_tabs)
{
    global $CONFIG, $CURRENT_ALBUM_DATA, $USER, $superCage;
    global $template_thumb_view_title_row,$template_fav_thumb_view_title_row, $lang_thumb_view, $lang_common, $template_tab_display;
    global $lang_album_list, $template_thumbnail_view, $stream_mode, $lang_plugin_stream;

    include 'write_stream.inc.php';
    include 'stream_templates.inc.php';
    $superCage = Inspekt::makeSuperCage();

    static $footer = '';
    static $tabs = '';
    static $spacer = '';
    $date='';
    $stream_mode = true;  // flag to be used in plugin to determine if we are currently displaying a stream or grid
    if ($tabs == '') {
        // Pick the standard templates where appropriate in case they have been modified in theme
        $tabs = template_extract_block($template_thumbnail_view, 'tabs');
        $footer = template_extract_block($template_thumbnail_view, 'footer');
        $spacer = template_extract_block($template_thumbnail_view, 'spacer');
    }
    $cat_link = is_numeric($aid) ? '' : '&amp;cat=' . $cat;
    $date_link = $date=='' ? '' : '&amp;date=' . $date;
    if ($superCage->get->getInt('uid')) {
      $uid_link = '&amp;uid=' . $superCage->get->getInt('uid');
    } else {
      $uid_link = '';
    }
    $album_types = array(
        'albums' => array('lastalb')
    );
    if (!GALLERY_ADMIN_MODE && stripos($template_thumb_view_title_row, 'admin_buttons') !== false) {
        template_extract_block($template_thumb_view_title_row, 'admin_buttons');
    }
    $display_buttons_in_separate_row = ($CONFIG['stream_buttons_separate'] == 1);
    // Display radio buttons if not logged in but permitted to choose - or logged in and either logged-in users or all users are permitted to choose
    $display_selector_radio_btns = (($user == 0) && ($CONFIG['stream_user_choice'] == 2)) || (($user <> 0) && ($CONFIG['stream_user_choice'] > 0));
    if (((($user == 0 ) && ($CONFIG['stream_user_choice'] == 2)) || (($user <> 0) && ($CONFIG['stream_user_choice'] > 0))) 
            && (!$display_buttons_in_separate_row)) {              // If user allowed to choose the mode and buttons are in the title line
        $stream_selector = template_extract_block($stream_master_templates, 'stream_selector_stream_mode');  // Get the radio buttons and text from template
        // Want to put the buttons after the album title so look for the end of the table cell i.e. </td>
        $title_row_html = substr_replace($template_thumb_view_title_row, $stream_selector, strpos($template_thumb_view_title_row, '</td>'), strlen('</td>'));
        // want to add td width attribute so replace the existing class attribute with width and class attributes combined
        $title_row_html = substr_replace($title_row_html, ('width="40%"' . ' class="statlink"'), strpos($title_row_html, 'class="statlink"'), strlen('class="statlink"'));
    } else {
        $title_row_html = $template_thumb_view_title_row;
    }
    if (is_numeric($aid)) {       // Display sort options only for numeric (real, not meta) albums
        if (GALLERY_ADMIN_MODE) {
            $param = array(
                '{ALBUM_ID}'   => $aid,
                '{CAT_ID}'     => ($cat > 0 ? $cat : $CURRENT_ALBUM_DATA['category']),
                '{MODIFY_LNK}'     => $lang_common['album_properties'],
                '{MODIFY_ICO}'     => cpg_fetch_icon('modifyalb', 0),
                '{PARENT_CAT_LNK}' => $lang_common['parent_category'],
                '{PARENT_CAT_ICO}' => cpg_fetch_icon('category', 0),
                '{EDIT_PICS_LNK}'  => $lang_common['edit_files'],
                '{EDIT_PICS_ICO}'  => cpg_fetch_icon('edit', 0),
                '{ALBUM_MGR_LNK}'  => $lang_common['album_manager'],
                '{ALBUM_MGR_ICO}'  => cpg_fetch_icon('alb_mgr', 0),
            );
        } else {
            $param = array();
    /******************* Below code block lifted unchanged from display_thumbnails in functions.inc.php ***************/
            // Add a hit to album counter if it is a numeric album
            if (is_numeric($aid)) {

                // Create an array to hold the album id for hits (if not created)
                if (!isset($USER['liv_a']) || !is_array($USER['liv_a'])) {
                    $USER['liv_a'] = array();
                }
                // Add 1 to album hit counter
                if ((!USER_IS_ADMIN && $CONFIG['count_admin_hits'] == 0 || $CONFIG['count_admin_hits'] == 1) && !in_array($aid, $USER['liv_a']) && $superCage->cookie->keyExists($CONFIG['cookie_name'] . '_data')) {

                    add_album_hit($aid);

                    if (count($USER['liv_a']) > 4) {
                        array_shift($USER['liv_a']);
                    }

                    array_push($USER['liv_a'], $aid);
                    user_save_profile();
                }
            }
    /******************* Above code block lifted unchanged from display_thumbnails in functions.inc.php ***************/
        }
        $param['{ALBUM_NAME}'] = $album_name;
        // Plugin Filter: allow plugin to modify or add tags to process
        $param = CPGPluginAPI::filter('theme_thumbnails_title', $param);
        $title = template_eval($title_row_html, $param);
    } elseif ($aid == 'favpics' && $CONFIG['enable_zipdownload'] > 0) { //Lots of stuff can be added here later
        $param = array(
            '{ALBUM_ID}'   => $aid,
            '{ALBUM_NAME}' => $album_name,
            '{DOWNLOAD_ZIP}' => cpg_fetch_icon ('zip', 2) . $lang_thumb_view['download_zip'],
        );
        // Plugin Filter: allow plugin to modify or add tags to process
        $param = CPGPluginAPI::filter('theme_thumbnails_title', $param);
        // If displaying buttons in the title row substitute the relevant HTML in the title row
        if (!$display_buttons_in_separate_row) {
            $title_row_html = substr_replace($template_fav_thumb_view_title_row, $stream_selector, strpos($template_fav_thumb_view_title_row, '</td>'), strlen('</td>'));
        }
        $title = template_eval($template_fav_thumb_view_title_row, $param);
    } else {                                                                // Meta album
        $param['{ALBUM_NAME}'] = $album_name;
        // Plugin Filter: allow plugin to modify or add tags to process
        $param = CPGPluginAPI::filter('theme_thumbnails_title', $param);
        $title = template_eval($title_row_html, $param);
     }
    $title_bar_html = starttable('100%', $title, $CONFIG['thumbcols'], '', TRUE);  // Generate the album title and sort options HTML
    if (($display_selector_radio_btns) && (!$display_buttons_in_separate_row)) {           //  Radio buttons in title line for those users allowed to choose
        $grid_num_pics_page = $CONFIG['thumbcols'] * $CONFIG['thumbrows'];
        if ($grid_num_pics_page == $CONFIG['stream_num_pics_page']) {
            $grid_page = 1;
        } else {
            $grid_page = ceil((1 + (($page - 1) * $CONFIG['stream_num_pics_page'])) /$grid_num_pics_page);
        }
        $hidden_cat_html = (($cat == 0) ? '' : ('<input type="hidden" name="cat" value="' . $cat . '" />'));
        $param = array(
            '{ALBUM_ID}'             => $aid,
            '{PAGE}'                 => $grid_page,
            '{HIDDEN_CAT}'           => $hidden_cat_html,
            '{GRID}'                 => $lang_plugin_stream['grid'],
            '{STREAM}'               => $lang_plugin_stream['stream'],
            '{BUTTON_TITLE}'         => $lang_plugin_stream['button_title'],
        ); 
        $title_bar_html = template_eval($title_bar_html, $param);           // Substitute the value for the radio button
    }
    echo $title_bar_html;  // Write out the title bar to the screen

    $theme_thumb_tab_tmpl = $template_tab_display;
    $theme_thumb_tab_tmpl['left_text'] = strtr($theme_thumb_tab_tmpl['left_text'], array('{LEFT_TEXT}' => in_array($aid, $album_types['albums']) ? $lang_album_list['album_on_page'] : $lang_thumb_view['pic_on_page']));
    $theme_thumb_tab_tmpl['page_link'] = strtr($theme_thumb_tab_tmpl['page_link'], array('{LINK}' => 'thumbnails.php?album=' . $aid . $cat_link . $date_link . $uid_link . '&amp;page=%d&amp;thumb_mode=stream'));

    if ($display_buttons_in_separate_row && $display_selector_radio_btns) {  // If selector buttons are wanted on a separate line, write them out after the page navigation stuff
        echo stream_buttons_stream_mode($grid_page);
    }
    if ($CONFIG['stream_page_nav'] && $display_tabs) {          // If we want to display page navigation above the stream
        $tabs_html = create_tabs($total_thumbs, $page, $total_pages, $theme_thumb_tab_tmpl);
        $revised_tabs_html = str_replace('tabs_dropdown', 'tabs_dropdown2', $tabs_html);  // Rename these items to prevent clash with the second set of page navigation which prevents dropdown from working
        echo $revised_tabs_html;
    }

    write_stream($thumb_list, $thumbs_to_display, $page, $aid);

    $footer = CPGPluginAPI::filter('theme_thumbnails_footer', $footer); 
    echo $footer;

    if ($display_tabs) {
        $tabs_html = create_tabs($total_thumbs, $page, $total_pages, $theme_thumb_tab_tmpl);
        echo $tabs_html;
    }

    endtable();
    CPGPluginAPI::action('theme_thumbnails_wrapper_end', null); 
    echo $spacer;
}
/******************************************************************************
** Section display_stream.inc.php - END
******************************************************************************/


?>
