<?php
/******************************************************************************
** write_stream.inc.php
*  Coppermine 1.6.x Plugin - stream. Created by KF for Photostream style thumbnail display 
*  Writes out the thumbnails (passed in) in stream format
*  Updated by KF April 2024 to i) add plugin interface which allows a picture URL to be changed
*                           ii) Allow limited display of non-image files 
*  Version 1.1
*          1.1.3    Bug fixes involving incorrect display of meta-albums in certain circumstances. Add more data
*                   to array passed to plugin hook
*  @since  1.6.22
******************************************************************************/
function write_stream(&$thumb_list, $num_thumbs, $page, $aid)
{
    global $CONFIG, $THEME_DIR, $lang_get_pic_data, $lang_errors, $lang_plugin_stream;
    include 'stream_templates.inc.php';
    
    $target_stream_width  = $CONFIG['stream_width'];         // px Width of total stream
    $short_stream_height  = $CONFIG['stream_min_height'];    // px Height of slimmest stream.
    $tall_stream_height   = $CONFIG['stream_max_height'];    // px Height of tallest stream. Was 400
    $thumb_divider        = $CONFIG['stream_divider'];       // px Width of border between pics
    $max_pics_stream_page = $CONFIG['stream_num_pics_page']; // maximum number of pictures on a stream page
    $comment_section_width = 40;      // px width of comment numeral plus icon and padding. Used to calculate max width of uploader name string.
    $comment_icon_str = '<img src="images/icons/comment.png" class="stream_class_comment_icon">';  // HTML Details of the comment icon
    $views_section_width = 65;      // px width of views numeral plus text and padding. Used to calculate max width of rating string incl icons. 
    $views_section_absent_width = 10;  // px to subtract when views not displayed. Used to calculate max width of rating string incl icons 
    $uploader_divider_string = "&nbsp:&nbsp";  // String used to divide uploader name and title - if both present
    $thumb_index = 0;  // The array of thumbs passed in starts at 0 and goes up to (number of thumbs - 1)
    $rows_on_page = 0;
    $stream_templates = array(
        'section_start' => '',
        'row_start' => '',
        'empty_cell' => '',
        'thumb_cell' => '',
        'row_end' => '',
        'section_end' => '',
    );
    $stream_templates['section_start'] = template_extract_block($stream_master_templates, 'stream_section_start');
    $stream_templates['row_start'] = template_extract_block($stream_master_templates, 'stream_row_start');
    $stream_templates['empty_cell'] = template_extract_block($stream_master_templates, 'stream_empty_cell');
    $stream_templates['thumb_cell'] = template_extract_block($stream_master_templates, 'stream_thumb_cell');
    $stream_templates['row_end'] = template_extract_block($stream_master_templates, 'stream_row_end');
    $stream_templates['section_end'] = template_extract_block($stream_master_templates, 'stream_section_end');       
    $PageDone = false;
    $thumbs_processed = 0; // Index for latest thumb in previous row
    $total_thumbs = min($num_thumbs, $max_pics_stream_page);  // Stop after reaching end of stream or max page size
    $params = array(
        '{COLSPAN}'   => $CONFIG['thumbcols'],
    );
    echo template_eval($stream_templates['section_start'], $params);  // // Write out the one-off HTML data to start the stream
// Loop through all the thumbs passed in until reaching end of thumbs or end of page
    while ($thumb_index < $total_thumbs) {
        $RowDone = false;
        $total_short_stream_width = 0;
        $total_tall_stream_width = 0;
        $thumbs_in_row = 0;
        $rows_on_page++;
        $full_row = false;
        do {  // for each thumbnail figure out how many per row 
            $thumbs_in_row++;
            // First check if the file in the list is actually an image and if not substitute the relevant thumb information
            $thumb_list[$thumb_index]['is_an_image'] = (is_image($thumb_list[$thumb_index]['filename']) <> null);
            if (!$thumb_list[$thumb_index]['is_an_image']) {
                $pic_url = get_pic_url($thumb_list[$thumb_index], 'thumb');  // Noting we expect intermediates to be suitably sized for the stream
                $image_info     = cpg_getimagesize(urldecode($pic_url));
                $thumb_list[$thumb_index]['pwidth']  = $image_info[0];
                $thumb_list[$thumb_index]['pheight'] = $image_info[1];
            }
            $pic_width[$thumbs_in_row] = intval($thumb_list[$thumb_index]['pwidth']);
            $pic_height[$thumbs_in_row] = intval($thumb_list[$thumb_index]['pheight']);
            if ($is_an_image) {  // Only do these checks if it's an image. If some other file it will use the CPG icons which are OK for orientation
                // Need to check image orientation and potentially adjust. If orientation is not "normal" the web browser will correctly rotate the 
                // image but the calculations will be wrong because the height and width are the reverse way round 
                $src_string = "albums/" . $thumb_list[$thumb_index]['filepath'] . $thumb_list[$thumb_index]['filename'];
                $exif = exif_read_data($src_string);  // Get the orientation flag from the exif data
                $rotate90 = false;
                if (array_key_exists('Orientation',$exif)) {
                    $orientation_flag = $exif['Orientation'];
                    if(($orientation_flag == '6') || ($orientation_flag == '8'))  {     // If orientation says rotate 90 or 270 degrees
                        $rotate90 = true;
                        $pic_width[$thumbs_in_row] = intval($thumb_list[$thumb_index]['pheight']);
                        $pic_height[$thumbs_in_row] = intval($thumb_list[$thumb_index]['pwidth']);
                    }   
                }    
            }                 
            $total_short_stream_width += ($pic_width[$thumbs_in_row] * ($short_stream_height / $pic_height[$thumbs_in_row])) + ($thumbs_in_row==1 ? 0 : $thumb_divider);
            $total_tall_stream_width += ($pic_width[$thumbs_in_row] * ($tall_stream_height / $pic_height[$thumbs_in_row])) + ($thumbs_in_row==1 ? 0 : $thumb_divider);
            $thumb_index++;
            if (($total_short_stream_width > $target_stream_width)
                || (($total_short_stream_width <= $target_stream_width) 
                    && ($total_tall_stream_width >= $target_stream_width))) {
                $full_row = true;
                $RowDone = true; 
            } else {
                $RowDone = ($thumb_index == $total_thumbs);   // Have we got to the end of the set of thumbs
            }                
        } while (!$RowDone) ;
        if (!$PageDone) {
            // Write out the HTML for the pictures               
            if ($full_row) {   // Here it's a full row of thumbs
                $denominator = 0;
                for ($i = 1; $i <= $thumbs_in_row; $i++) {
                    $denominator += $pic_width[$i] / $pic_height[$i];
                }
                $row_height = round(($target_stream_width - ($thumbs_in_row - 1) * $thumb_divider) / $denominator);
            } else {    // Here it's an incomplete row of thumbs needing an empty thumb on the end
                $row_height = $tall_stream_height;   // Make the height of the incomplete row the maximum we allow
            }
           // Now write out the HTML and thumbs
            $params = array('{STREAM_WIDTH}' => $target_stream_width);
            echo template_eval($stream_templates['row_start'], $params);  // Start the stream row
            for ($i = 1; $i <= $thumbs_in_row; $i++) {
                $stream_pic_width[$i] = round($pic_width[$i] * $row_height / $pic_height[$i]);   // Width of each thumbnail in the row to be used to display it
                $stream_pic_height[$i] = $row_height;
                $cell_margin_left = ($i==1) ? 0 : $thumb_divider; // Left margin is zero for first cell, width of cell divider for all others 
                $thumb_position = $i + $thumbs_processed - 1;  // Thumbs in array passed in start from zero
                $thumb_list[$thumb_position] = CPGPluginAPI::filter('stream_display_thumbnail_start', $thumb_list[$thumb_position]);    // Allow any of the thumbnail details to be read or changed by another plugin
                if ($CONFIG['thumbnail_to_fullsize'] == 1) { // code for full-size pop-up
                    if (!USER_ID && $CONFIG['allow_unlogged_access'] <= 2) {
                       $link_tgt_string = 'javascript:;" onclick="alert(\''.sprintf($lang_errors['login_needed'],'','','','').'\');';
                    } elseif (USER_ID && USER_ACCESS_LEVEL <= 2) {
                    $link_tgt_string = 'javascript:;" onclick="alert(\''.sprintf($lang_errors['access_intermediate_only'],'','','','').'\');';
                    } else {
                       $link_tgt_string = 'javascript:;" onclick="MM_openBrWindow(\'displayimage.php?pid=' . $thumb_list[$thumb_position]['pid'] . '&fullsize=1\',\'' . uniqid(rand()) . '\',\'scrollbars=yes,toolbar=no,status=no,resizable=yes,width=' . ((int)$thumb_list[$thumb_position]['pwidth']+(int)$CONFIG['fullsize_padding_x']) .  ',height=' .   ((int)$thumb_list[$thumb_position]['pheight']+(int)$CONFIG['fullsize_padding_y']). '\');';
                    }
                } else {
//                    $link_tgt_string = "displayimage.php?album={$thumb_list[$thumb_position]['aid']}&amp;pid={$thumb_list[$thumb_position]['pid']}&amp;return_page={$page}&amp;thumb_mode=stream#top_display_media";
                    if ($aid == 'lastcom') {
                        $link_tgt_string = "displayimage.php?album={$aid}&amp;pid={$thumb_list[$thumb_position]['pid']}&amp;msg_id={$thumb_list[$thumb_position]['msg_id']};return_page={$page}&amp;thumb_mode=stream#top_display_media";
                    } else {
                        $link_tgt_string = "displayimage.php?album={$aid}&amp;pid={$thumb_list[$thumb_position]['pid']}&amp;return_page={$page}&amp;thumb_mode=stream#top_display_media";
                    }
                }
                $link_string = '<A HREF="' . $link_tgt_string . '">';
                $alt_string = '';
                if ($thumb_list[$thumb_position]['is_an_image']) {
                    $fullsize_string = "albums/" . $thumb_list[$thumb_position]['filepath'] . $thumb_list[$thumb_position]['filename'];
                    $src_string = $fullsize_string;  // By default use the full size image
                    $not_found_div = '';
                    if ($CONFIG['make_intermediate'] == 1) {
                        $intermediate_prefix =  "normal_";
                        $int_string = "albums/" . $thumb_list[$thumb_position]['filepath'] . $intermediate_prefix . $thumb_list[$thumb_position]['filename'];
                        if (file_exists($int_string)) {    //If we're using intermediate files and the image exists - use it
                            $src_string = $int_string;
                        } elseif (!file_exists($fullsize_string)) {  // Otherwise display message that the image is missing
                            $not_found_string = sprintf($lang_plugin_stream['image_not_found'], ($thumb_list[$thumb_position]['filepath'] . $thumb_list[$thumb_position]['filename']));
                            $not_found_div = '<div class="thumb_caption" id="stream_id_image_missing">' . $not_found_string . '</div>';
                        }
                    }
                } else {
                    $src_string = $thumb_list[$thumb_position]['url_prefix'];   // Name is misleading. It's not a URL. For a non-image it's the name of the icon to represent it 
                }
                $title_section = '<div class="thumb_title" id="stream_id_title">' . $thumb_list[$thumb_position]['title'] . '</div>';
                if ($CONFIG['display_uploader']==1) {    
                    // Get uploader name
                    $query = "SELECT user_name, user_id FROM {$CONFIG['TABLE_USERS']} INNER JOIN {$CONFIG['TABLE_PICTURES']} ON user_id = owner_id WHERE pid = {$thumb_list[$thumb_position]['pid']}";
                    if ($usrData = cpg_db_fetch_assoc(cpg_db_query($query))) {    // Uploader is never blank
                         $upl_section = '<div id="stream_id_uploader" class="thumb_title"><a href="profile.php?uid=' . $usrData['user_id'] . '">' . $usrData['user_name'] . '</a>' . $uploader_divider_string . '</div>';
                    } else {
                        $upl_section = '';  // should never reach here
                    }
                } else {
                    $upl_section = '';
                };     
                $upl_title_section = $upl_section . $title_section;;  // Title is always displayed - as with standard Coppermine thumbnail display
                $num_comments = count_pic_comments($thumb_list[$thumb_position]['pid']);
                $display_comments = ($num_comments > 0) && ($CONFIG['display_comment_count'] == 1);  // Display comments if configured and more than zero
                $comment_string = $display_comments ? ($num_comments . $comment_icon_str) : '' ;  // Create comment string to go on screen if it's going to be displayed, otherwise blank
                // Calculate width of space available for Uploader and title string using image width and margins on both side. The figure on the right is pixels and allows for padding etc
                $upl_title_width = ($stream_pic_width[$i] - ($display_comments ? $comment_section_width : 6));
                $description_section = (($CONFIG['caption_in_thumbview'] == 1) ? ('<div class="thumb_caption" id="stream_id_description">' . $thumb_list[$thumb_position]['caption'] . "</div>") : ''); 
                $rating_displayed = false;
                $border_shift = ($thumb_divider == 0) ? 0 : ceil($thumb_divider/2);  // Move the faint borders (dividers) between photo details to better line them up with images
                $border_style_left = ($i == 1) ? 'left:0px' : ('left:' . -$border_shift . 'px');  // Move left border (divider) except at beginning of row
                $border_style = 'style="' . $border_style_left . '"';
                if (($CONFIG['display_thumbnail_rating'] == 1) || ($aid == 'toprated')) {
                    if (defined('THEME_HAS_RATING_GRAPHICS')) {
                        $prefix = $THEME_DIR;
                    } else {
                        $prefix = '';
                    }
                    $rating_displayed = true;
                    //calculate required amount of rating stars
                    $rating        = round(($thumb_list[$thumb_position]['pic_rating'] / 2000) / (5 / $CONFIG['rating_stars_amount']));
                    $rating_images = '';
                    for ($star = 1; $star <= $CONFIG['rating_stars_amount']; $star++) {
                       if ($star <= $rating) {
                            $rating_images .= '<img src="' . $prefix . 'images/rate_full.png" alt="' . $rating . '"/>';
                        } else {
                            $rating_images .= '<img src="' . $prefix . 'images/rate_empty.png" alt="' . $rating . '"/>';
                        }
                    }
                }
                $hits_string = ((($CONFIG['views_in_thumbview'] == 1) || 
                    ($aid == 'topn')) ? '<div class="thumb_title" id="stream_id_views">' . sprintf($lang_get_pic_data['n_views'], $thumb_list[$thumb_position]['hits']) . '</div>' : '');  // Most viewed
                if ($rating_displayed || $hits_string <> '') {
                    $details_holder_class = 'stream_class_image_details_holder_two_rows';
                    $rating_hits_div = '<div class="stream_class_rating_views id="stream_id_rating_views">';
                    $rating_hits_div_end = '</div>';
                    $rating_string_width = ($CONFIG['views_in_thumbview'] == 1) ? $stream_pic_width[$i] - $views_section_width : $stream_pic_width[$i] - $views_section_absent_width;
                    $details_right_edge = ($i == $thumbs_in_row) ? '<div class="stream_class_image_details_right_edge_two_rows" style="right:' . -$border_shift . 'px">' : '';  // Element at right side of row to draw in the border on the edge
                } else {
                    $details_holder_class = 'stream_class_image_details_holder_one_row';
                    $rating_hits_div = '';
                    $rating_hits_div_end = '';
                    $details_right_edge = ($i == $thumbs_in_row) ? '<div class="stream_class_image_details_right_edge_one_row" style="right:' . -$border_shift . 'px">' : '';  // Element at right side of row to draw in the border on the edge
                }
                $rating_string = $rating_displayed ? '<div class="stream_class_rating" id="stream_id_rating" style="width:' . $rating_string_width . 'px"><div class="stream_class_rating_images" id="stream_id_rating_images">' . $rating_images . 
                                   '</div><div id="stream_id_votes" class="thumb_caption">' . sprintf($lang_get_pic_data['n_votes'], $thumb_list[$thumb_position]['votes']) . '</div></div>' : '';
                $params = array(
                        'aid'                   => $thumb_list[$thumb_position]['aid'],
                        'pid'                   => $thumb_list[$thumb_position]['pid'],
                        'owner_id'              => $thumb_list[$thumb_position]['owner_id'],
                        '{CELL_WIDTH}'          => $stream_pic_width[$i],
                        '{CELL_HEIGHT}'         => $stream_pic_height[$i],
                        '{MARGIN_LEFT}'         => $cell_margin_left,
                        '{LINK_STRING}'         => $link_string,
                        '{SRC_STRING}'          => $src_string,
                        '{ALT_STRING}'          => $alt_string,
                        '{ROW_HEIGHT}'          => $row_height . "px",
                        '{MISSING_MESSAGE}'     => $not_found_div,
                        '{DESCRIPTION_SECTION}' => $description_section,
                        '{UPL_TITLE_SECTION}'   => $upl_title_section,
                        '{UPL_TITLE_WIDTH}'     => $upl_title_width,
                        '{COMMENT_SECTION}'     => $comment_string,
                        '{DETAILS_HOLDER_CLASS}'=> $details_holder_class,
                        '{DETAILS_WIDTH}'       => $stream_pic_width[$i],
                        '{BORDER_STYLE}'        => $border_style, 
                        '{RATING_HITS_DIV}'     => $rating_hits_div,
                        '{RATING_SECTION}'      => $rating_string,
                        '{HITS_SECTION}'        => $hits_string,
                        '{RATING_HITS_END_DIV}' => $rating_hits_div_end,
                        '{DETAILS_RIGHT_EDGE}'  => $details_right_edge,
                );
                $params = CPGPluginAPI::filter('stream_display_thumbnails_params', $params);    // Allow any of the above to be changed by another plugin
                echo template_eval($stream_templates['thumb_cell'], $params);  // Write out HTML for each stream cell
            }
            $thumbs_processed += $thumbs_in_row;  // Keep count of no of thumbs processed
            if (!$full_row) {  // If the last row is incomplete write out an empty cell to complete the row - after calculating its size
                $blank_width = $target_stream_width - round($total_tall_stream_width) - $thumb_divider;  // Subtract width of pics already in row and width of divider 
                $params = array(
                    '{CELL_WIDTH}'   => $blank_width,
                );
                echo template_eval($stream_templates['empty_cell'], $params);
            }
            echo $stream_templates['row_end'];   // Complete the table row  
            if ($thumb_index == $total_thumbs) {   // If all thumbs have been processed
                echo $stream_templates['section_end'];   // Write out HTML for end of page and finish
                $PageDone = true;
            }
        }
    }
}
?>
            
