<?php
/******************************************************************************
** config.php
*  Coppermine 1.6.x Plugin - suppressor. Created by KF to suppress file information and sub-menu options
*  Version 1.0
* @since  1.6.22
******************************************************************************/
global $lang_plugin_suppressor;
// create Inspekt supercage
$superCage = Inspekt::makeSuperCage();

// Make sure that this file can't be accessed directly, but only from within the Coppermine user interface
if (!defined('IN_COPPERMINE')) {
    die('Not in Coppermine...');
}

if (!GALLERY_ADMIN_MODE) {
    cpg_die(ERROR, $lang_errors['access_denied'], __FILE__, __LINE__);
}
suppressor_init_settings($suppressor_setting);
$suppressor_setting_block = $CONFIG['suppressor_settings'];

// get sanitized POST parameters
if ($superCage->post->keyExists('submit')) {
  // Define the sanitization patterns. Note that the array keys have spaces replaced by underscore
    $sanitization_array = array(
      'Filename'             => array('type' => 'checkbox', 'min' => '0', 'max' => '1'),
      'Filesize'             => array('type' => 'checkbox', 'min' => '0', 'max' => '1'),
      'Date_added'           => array('type' => 'checkbox', 'min' => '0', 'max' => '1'),
      'Dimensions'           => array('type' => 'checkbox', 'min' => '0', 'max' => '1'),
      'Displayed'            => array('type' => 'checkbox', 'min' => '0', 'max' => '1'),
      'DateTime_Original'    => array('type' => 'checkbox', 'min' => '0', 'max' => '1'),
      'URL'                  => array('type' => 'checkbox', 'min' => '0', 'max' => '1'),
      'Favorites'            => array('type' => 'checkbox', 'min' => '0', 'max' => '1'),
      'Search'               => array('type' => 'checkbox', 'min' => '0', 'max' => '1'),
      'Top_rated'            => array('type' => 'checkbox', 'min' => '0', 'max' => '1'),
      'Most_viewed'          => array('type' => 'checkbox', 'min' => '0', 'max' => '1'),
      'Last_Comments'        => array('type' => 'checkbox', 'min' => '0', 'max' => '1'),
      'Last_Uploads'         => array('type' => 'checkbox', 'min' => '0', 'max' => '1'),     
      'Keywords'             => array('type' => 'checkbox', 'min' => '0', 'max' => '1')      
    );
    $config_changes_counter = 0;
    foreach ($sanitization_array as $san_key => $san_value) {           
        $stored_setting = substr($suppressor_setting_block, ($suppressor_setting[$san_key] -1), 1);  // String counting starts from 0, not 1
        if ($san_value['type'] == 'checkbox') { // type is checkbox --- start
            if ($superCage->post->keyExists($san_key)) {
                if ($superCage->post->getInt($san_key) <= $san_value['max'] && 
                        $superCage->post->getInt($san_key) >= $san_value['min'] && 
                        strval($superCage->post->getInt($san_key)) != $stored_setting) {
                    $new_setting = strval($superCage->post->getInt($san_key));
                    $suppressor_setting_block = substr_replace($suppressor_setting_block, $new_setting, ($suppressor_setting[$san_key] -1), 1);
                    $config_changes_counter++;
                }
            } else {  // blank which is 0 i.e. don't display
                if ($stored_setting <> '0') {   // if stored setting isn't already 0, update it. Otherwise leave unchanged
                    $suppressor_setting_block = substr_replace($suppressor_setting_block, '0', ($suppressor_setting[$san_key] -1), 1);
                    $config_changes_counter++;
                }
            }
        } // type is checkbox --- end
    }
    if ($config_changes_counter > 0) {
        cpg_db_query("UPDATE {$CONFIG['TABLE_CONFIG']} SET value='{$suppressor_setting_block}' WHERE name='suppressor_settings'");
    }
}

// display config page
$submit_icon = cpg_fetch_icon('ok', 1);

// Set the option output stuff 
foreach ($suppressor_setting as $setting_key => $setting_value) {
    if (substr($suppressor_setting_block, ($setting_value - 1), 1) == "1") {
        $option_output[$setting_key] = 'checked="checked"';
    } else {
        $option_output[$setting_key] = '';
    }
}

if ($superCage->post->keyExists('submit')) {
    if ($config_changes_counter > 0) {
        msg_box('', $lang_plugin_suppressor['update_success'], '', '', 'success');
    } else {
        msg_box('', $lang_plugin_suppressor['no_changes'], '', '', 'info');
    }
}

// Identify the plugin being configured
starttable('100%', sprintf($lang_plugin_suppressor['configure_x'], $lang_plugin_suppressor['plugin_name']), 3, 'cpg_zebra');
// Note that the option_output fields have any spaces in the field name replaced by underscore
echo <<<EOT
    <!-- insert config option form code start -->
    <tr>
		<td class="tableb" width="30%">
            <label for="Filename" class="clickable_option">{$lang_plugin_suppressor['Filename']}</label>
        </td>
        <td>
            <input type="checkbox" name="Filename" id="Filename" class="checkbox" value="1" {$option_output['Filename']}/>
            <label for="Filename" class="clickable_option">{$lang_plugin_suppressor['yes']}</label>
        </td>
    </tr>
    <tr>
		<td class="tableb" width="30%">
            <label for="Filesize" class="clickable_option">{$lang_plugin_suppressor['Filesize']}</label>
        </td>
        <td>
            <input type="checkbox" name="Filesize" id="Filesize" class="checkbox" value="1" {$option_output['Filesize']}/>
            <label for="Filesize" class="clickable_option">{$lang_plugin_suppressor['yes']}</label>
        </td>
    </tr>
    <tr>
		<td class="tableb" width="30%">
            <label for="Date added" class="clickable_option">{$lang_plugin_suppressor['Date added']}</label>
        </td>
        <td>
            <input type="checkbox" name="Date added" id="Date added" class="checkbox" value="1" {$option_output['Date_added']}/>
            <label for="Date added" class="clickable_option">{$lang_plugin_suppressor['yes']}</label>
        </td>
    </tr>
    <tr>
		<td class="tableb" width="30%">
            <label for="Dimensions" class="clickable_option">{$lang_plugin_suppressor['Dimensions']}</label>
        </td>
        <td>
            <input type="checkbox" name="Dimensions" id="Dimensions" class="checkbox" value="1" {$option_output['Dimensions']}/>
            <label for="Dimensions" class="clickable_option">{$lang_plugin_suppressor['yes']}</label>
        </td>
    </tr>
    <tr>
		<td class="tableb" width="30%">
            <label for="Displayed" class="clickable_option">{$lang_plugin_suppressor['Displayed']}</label>
        </td>
        <td>
            <input type="checkbox" name="Displayed" id="Displayed" class="checkbox" value="1" {$option_output['Displayed']}/>
            <label for="Displayed" class="clickable_option">{$lang_plugin_suppressor['yes']}</label>
        </td>
    </tr>
    <tr>
		<td class="tableb" width="30%">
            <label for="DateTime Original" class="clickable_option">{$lang_plugin_suppressor['DateTime Original']}</label>
        </td>
        <td>
            <input type="checkbox" name="DateTime_Original" id="DateTime Original" class="checkbox" value="1" {$option_output['DateTime_Original']}/>
            <label for="DateTime Original" class="clickable_option">{$lang_plugin_suppressor['yes']}</label>
        </td>
    </tr>
    <tr>
		<td class="tableb" width="30%">
            <label for="URL" class="clickable_option">{$lang_plugin_suppressor['URL']}</label>
        </td>
        <td>
            <input type="checkbox" name="URL" id="URL" class="checkbox" value="1" {$option_output['URL']}/>
            <label for="URL" class="clickable_option">{$lang_plugin_suppressor['yes']}</label>
        </td>
    </tr>
    <tr>
		<td class="tableb" width="30%">
            <label for="Favorites" class="clickable_option">{$lang_plugin_suppressor['Favorites']}</label>
        </td>
        <td>
            <input type="checkbox" name="Favorites" id="Favorites" class="checkbox" value="1" {$option_output['Favorites']}/>
            <label for="Favorites" class="clickable_option">{$lang_plugin_suppressor['yes']}</label>
        </td>
    </tr>
    <tr>
		<td class="tableb" width="30%">
            <label for="Search" class="clickable_option">{$lang_plugin_suppressor['Search']}</label>
        </td>
        <td>
            <input type="checkbox" name="Search" id="Search" class="checkbox" value="1" {$option_output['Search']}/>
            <label for="Search" class="clickable_option">{$lang_plugin_suppressor['yes']}</label>
        </td>
    </tr>
    <tr>
		<td class="tableb" width="30%">
            <label for="Top rated" class="clickable_option">{$lang_plugin_suppressor['Top rated']}</label>
        </td>
        <td>
            <input type="checkbox" name="Top rated" id="Top rated" class="checkbox" value="1" {$option_output['Top_rated']}/>
            <label for="Top rated" class="clickable_option">{$lang_plugin_suppressor['yes']}</label>
        </td>
    </tr>
    <tr>
		<td class="tableb" width="30%">
            <label for="Most viewed" class="clickable_option">{$lang_plugin_suppressor['Most viewed']}</label>
        </td>
        <td>
            <input type="checkbox" name="Most viewed" id="Most viewed" class="checkbox" value="1" {$option_output['Most_viewed']}/>
            <label for="Most viewed" class="clickable_option">{$lang_plugin_suppressor['yes']}</label>
        </td>
    </tr>
    <tr>
		<td class="tableb" width="30%">
            <label for="Last Comments" class="clickable_option">{$lang_plugin_suppressor['Last Comments']}</label>
        </td>
        <td>
            <input type="checkbox" name="Last Comments" id="Last Comments" class="checkbox" value="1" {$option_output['Last_Comments']}/>
            <label for="Last Comments" class="clickable_option">{$lang_plugin_suppressor['yes']}</label>
        </td>
    </tr>
    <tr>
		<td class="tableb" width="30%">
            <label for="Last Uploads" class="clickable_option">{$lang_plugin_suppressor['Last Uploads']}</label>
        </td>
        <td>
            <input type="checkbox" name="Last Uploads" id="Last Uploads" class="checkbox" value="1" {$option_output['Last_Uploads']}/>
            <label for="Last Uploads" class="clickable_option">{$lang_plugin_suppressor['yes']}</label>
        </td>
    </tr>
    <tr>
		<td class="tableb" width="30%">
            <label for="Keywords" class="clickable_option">{$lang_plugin_suppressor['Keywords']}</label>
        </td>
        <td>
            <input type="checkbox" name="Keywords" id="Keywords" class="checkbox" value="1" {$option_output['Keywords']}/>
            <label for="Keywords" class="clickable_option">{$lang_plugin_suppressor['yes']}</label>
        </td>
    </tr>
    <!-- insert config option form code end -->
    <tr>
        <td></td>
        <td class="tablef" colspan="3">
            <button type="submit" class="button" style="text-align:center" name="submit" value="{$lang_plugin_suppressor['submit']}">{$submit_icon}{$lang_plugin_suppressor['submit']}</button>
        </td>
    </tr>
EOT;

endtable();

//EOF
