<?php
defined('IN_COPPERMINE') or die('Not in Coppermine...');

abstract class U2FA
{

	public static function authenticate ($userdata)
	{
		global $CONFIG, $superCage;

		$sql = 'SELECT secret,ecodes FROM '.$CONFIG['TABLE_PREFIX'].'plugin_user2FA WHERE uid='.$userdata['user_id'];
		$rslt = cpg_db_query($sql);
		if (!$rslt) return true;
		$vals = $rslt->fetchRow(true);
		if (!$vals) return true;
		$secret = $vals[0];
		if (!$secret) return true;
		$code = $superCage->post->getEscaped('twofact');
		if (!$code) return false;

		if (strlen($code) == 12) {
			$valid = false;
			$eca = json_decode($vals[1], true);
			foreach ($eca as $k=>$v) {
				if ($v && $k == $code) {
					$valid = true;
					$eca[$k] = 0;
					$ecs = json_encode($eca);
					cpg_db_query("UPDATE {$CONFIG['TABLE_PREFIX']}plugin_user2FA SET ecodes = '{$ecs}'");
					break;
				}
			}
		} else {
			require 'gga.class.php';
			$ga = new PHPGangsta_GoogleAuthenticator();
			$valid = $ga->verifyCode($secret, $code, 2);
		}
		return $valid;
	}

	public static function menuLink ()
	{
		global $lang_plugin_user2FA, $template_sys_menu;

		$block = 'logout';		// we'll add it after the logout link
		$nblck = 'user2FA';
		$new_template = $template_sys_menu;
		$button = template_extract_block($new_template, $block);
		$params = array(
			'{LOGOUT_TGT}' => 'index.php?file=user2FA/user2fa',
			'{LOGOUT_TITLE}' => $lang_plugin_user2FA['config_title'],
			'{LOGOUT_LNK}' => $lang_plugin_user2FA['config_name'],
			'{LOGOUT_ICO}' => '<img src="plugins/user2FA/authentic.png" width="16" height="16" alt="2FA" class="icon" />'
		);
		$new_button = "<!-- BEGIN $nblck -->" . template_eval($button, $params) . "<!-- END $nblck -->\n";
		template_extract_block($template_sys_menu, $block, "<!-- BEGIN $block -->" . $button . "<!-- END $block -->\n".$new_button);
	}

	public static function install ($un=false)
	{
		global $CONFIG;
		$tbl = $CONFIG['TABLE_PREFIX'].'plugin_user2FA';
		if ($un) {
	    	cpg_db_query("DROP TABLE IF EXISTS {$tbl}");
		} else {
			$q = 'CREATE TABLE IF NOT EXISTS '.$tbl.'(uid INT(11), secret VARCHAR(31), ecodes VARCHAR(127)) COMMENT=\'For two factor user authentication\';';
			cpg_db_query($q);
		}
		return true;
	}
	
}
