<?php
defined('IN_COPPERMINE') or die('Not in Coppermine...');

$thisplugin->add_action('page_start', 'user2FA_menu_link');
function user2FA_menu_link ()
{
	if (!defined('PROFILE_PHP')) return;
	require 'plugins/user2FA/U2FA.php';
	U2FA::menuLink();
}


$thisplugin->add_filter('template_html', 'user2FA_template_html');
function user2FA_template_html ($html)
{
	if (defined('LOGIN_PHP')) {
		$pos = strripos($html, '</body>');
		if ($pos !== false) {
			$html = substr_replace($html, '<script src="plugins/user2FA/script.js"></script>', $pos, 0);
		}
	}
	return $html;
}

$thisplugin->add_action('authorize_user', 'user2FA_auth_user');
function user2FA_auth_user ($userdata)
{
	// if $userdata is FALSE, should just return false
	// (another plugin has rejected the login)
	if ($userdata === false) return false;

	require 'plugins/user2FA/U2FA.php';
	$valid = U2FA::authenticate($userdata);

	// if verified, return original userdata (for sake of plugin chain), otherwise return FALSE
	return $valid ? $userdata : false;
}


/*** INSTALL/UNINSTALL ***/

$thisplugin->add_action('plugin_install', 'user2FA_install');
function user2FA_install ()
{
	require 'plugins/user2FA/U2FA.php';
	return U2FA::install();
}

$thisplugin->add_action('plugin_uninstall', 'user2FA_uninstall');
function user2FA_uninstall ()
{
	require 'plugins/user2FA/U2FA.php';
	return U2FA::install(true);
}
