<?php
defined('IN_COPPERMINE') or die('Not in Coppermine...');

if (!USER_ID) cpg_die(ERROR, $lang_errors['access_denied'], __FILE__, __LINE__);

function user2fa_process_form ($sC)
{
	global $CONFIG, $lang_plugin_user2FA;

	$task = $sC->getEscaped('task');

	if ($task == 'disable') {
		cpg_db_query('DELETE FROM '.$CONFIG['TABLE_PREFIX'].'plugin_user2FA WHERE uid='.USER_ID);
		theme_msg_box('TITLE', $lang_plugin_user2FA['disabled'], 'cpg_message_success', '', '');
	} else if ($task == 'enable') {
		require_once 'gga.class.php';
		$secret = $sC->getEscaped('secret');
		$code = $sC->getEscaped('tfacode');
		$ga = new PHPGangsta_GoogleAuthenticator();
		if ($ga->verifyCode($secret, $code, 2)) {
			$eca = [];
			$str = '123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghjkmnpqrstuvwxyz';
			for ($i=0; $i<4; $i++) $eca[substr(str_shuffle($str),0,12)] = 1;
			$ec = json_encode($eca);
			$uid = USER_ID;
			cpg_db_query("INSERT INTO {$CONFIG['TABLE_PREFIX']}plugin_user2FA (uid,secret,ecodes) VALUES ({$uid},'{$secret}','{$ec}')");
			theme_msg_box('TITLE', $lang_plugin_user2FA['enabled'], 'cpg_message_success', '', '');
		} else {
			theme_msg_box('TITLE', 'INVALID: Not Enabled', 'cpg_message_error', '', '');
		}
	}
}

function user2fa_display_form ($secr, &$L)
{
	global $CONFIG, $superCage, $lang_common;

	echo '<form action="'.$superCage->server->getEscaped('REQUEST_URI').'" method="post">';

	if ($secr) {
		$eca = json_decode($secr[1], true);
		echo '<h4 class="ecodeh">'.$L['ecodes'].'</h4>';
		echo '<div class="ecodes">';
		foreach ($eca as $k=>$v) {
			if ($v) {
				echo $k.'<br>';
			} else {
				echo "<s>{$k}</s><br>";
			}
		}
		echo '</div>';
		$submit_icon = cpg_fetch_icon('delete', 1);
		echo <<<EOT
<button name="submit" class="button" type="submit"> {$submit_icon}{$L['disable']} </button>
<input type="hidden" name="task" value="disable" />
EOT;
	} else {
		require_once 'gga.class.php';

		$match = [];
		preg_match('#https?...(.*)$#', $CONFIG['ecards_more_pic_target'], $match);
		$account = USER_NAME .'@'. rtrim($match[1], '/');

		$ga = new PHPGangsta_GoogleAuthenticator();
		$secret = $ga->createSecret();

		$qrCodeUrl = $ga->getQRCodeGoogleUrl($account, $secret, $CONFIG['gallery_name']);

		$submit_icon = cpg_fetch_icon('ok', 1);
		echo <<<EOT
<div class="tFA-sect">{$L['step1']}</div>
<div class="tFA-secta">{$L['step1a']}</div>
<div class="tFA-sect">{$L['step2']}</div>
<div class="tFA-secta">{$L['step2a']}
	<table>
	<tr><td class="tFA-col1">Account</td><td><input class="tFA-txtf" type="text" value="{$account}" readonly></td></tr>
	<tr><td class="tFA-col1">Key</td><td><input class="tFA-txtf" type="text" value="{$secret}" readonly></td></tr>
	</table>
	<p>{$L['qrcode']}</p>
	<img src="{$qrCodeUrl}">
</div>
<div class="tFA-sect">{$L['step3']}</div>
<div class="tFA-secta">{$L['step3a']}
	<table>
	<tr><td class="tFA-col1">Security Code</td><td><input class="tFA-txtf" type="text" name="tfacode" value=""></td></tr>
	</table>
</div>
<button name="submit" class="button" type="submit"> {$submit_icon}{$L['enable']} </button>
<input type="hidden" name="secret" value="{$secret}" />
<input type="hidden" name="task" value="enable" />
EOT;
	}
	list($timestamp, $form_token) = getFormToken();
	echo "<input type=\"hidden\" name=\"form_token\" value=\"{$form_token}\" />";
	echo "<input type=\"hidden\" name=\"timestamp\" value=\"{$timestamp}\" />";
	echo '</form>';
}

pageheader($lang_plugin_user2FA['user2FA']);
echo '<style>
.tFA-sect {font-size: large; border-bottom: 1px solid #BBB;}
.tFA-secta {margin-bottom: 2em;}
.tFA-col1 {width: 10em;}
.tFA-txtf {width: 20em;}
button.button {padding: 3px 6px; font-size: larger;}
.ecodeh {padding-bottom: 3px; border-bottom: 1px solid #BBB; margin-bottom: 0.5em;}
.ecodes {font-family: Courier, monospace; font-size:larger; margin-bottom: 2em;}
.ecodes s {color: #999;}
</style>';

if ($superCage->post->keyExists('submit')) {
	if (!checkFormToken()) {
		global $lang_errors;
		cpg_die(ERROR, $lang_errors['invalid_form_token'], __FILE__, __LINE__);
	}
	user2fa_process_form($superCage->post);
}

$sql = 'SELECT secret,ecodes FROM '.$CONFIG['TABLE_PREFIX'].'plugin_user2FA WHERE uid='.USER_ID;
$result = cpg_db_query($sql);
$secr = $result->fetchRow(true);

user2fa_display_form($secr, $lang_plugin_user2FA);

pagefooter();
