<?php
/******************************************************************************
** codebase.php
*  Coppermine 1.6.x Plugin - offline. Created by KF to redirect to a custom page if not an adminstrator
*  Version 1.0
*  @since  1.6.22
******************************************************************************/
// This is a very simple plugin which is intended to only allow admins access to the site
// If any non-admin accesses the gallery redirects to a custom page whose HTML is defined in  offlinepage.php

// Make sure that this file can't be accessed directly, but only from within the Coppermine user interface
if (!defined('IN_COPPERMINE')) {
    die('Not in Coppermine...');
}

// Define plugin actions here
$thisplugin->add_action('plugin_install', 'offline_install');
$thisplugin->add_action('plugin_uninstall', 'offline_uninstall');
$thisplugin->add_action('page_start', 'offline_run');

function offline_run() {
    global $CONFIG, $CPG_PHP_SELF;
    
    if ($CPG_PHP_SELF != "login.php") {
        if (!(USER_IS_ADMIN || USER_ADMIN_MODE)) {
            $loginpage = $CONFIG['ecards_more_pic_target'] . 'login.php';
            starttable("100%");
            // The file pulled in below contains the actual HTML to be displayed
            require('offlinehtml.php');  
            endtable();
            exit();
        }
    }
    return true;
}

function offline_install() {
    return true;
}

function offline_uninstall() {
    return true;
}

