<?php
defined('IN_COPPERMINE') or die('Not in Coppermine...');

// Don't allow access by non-admin users
if (!GALLERY_ADMIN_MODE) {
	cpg_die(ERROR, $lang_errors['access_denied'], __FILE__, __LINE__);
}


// Save the submitted configuration settings
function plg_theme_cache_config_save ($sC)
{
	global $lang_plugin_theme_cache, $lang_common, $lang_pluginmgr_php;

	// Get configuration values and save them
	$cachet = $sC->post->getInt('cachet');
	cpg_config_set('plg_theme_cache_optvals', json_encode(['cache_time'=>$cachet]), true);

	// Display a success message
	starttable('100%', $lang_common['information']);
	$msg = sprintf($lang_pluginmgr_php['saved_config'], $lang_plugin_theme_cache['config_name']);
	echo <<<EOT
	<tr>
		<td class="tableb" width="200">
			<div class="cpg_message_info">{$msg}</div>
		</td>
	</tr>
EOT;
	endtable();
	echo '<br />';
}


// Display a configuration setting form
function plg_theme_cache_config_form ($sC)
{
	global $CONFIG, $lang_common, $lang_plugin_theme_cache, $lang_gallery_admin_menu;
	
	$submit_icon = cpg_fetch_icon('ok', 1);
	$vals = json_decode($CONFIG['plg_theme_cache_optvals'], true);

	// Provide a configuration table header
	starttable('100%', $lang_plugin_theme_cache['config_name'].' - '.$lang_gallery_admin_menu['admin_lnk'], 2);

	// Display rows for config items and a save button
	echo <<<EOT
	<tr>
		<td colspan="2"><p>{$lang_plugin_theme_cache['blurb']}</p></td>
	</tr>
	<tr>
		<td class="tableb" width="40%"><label for="cachet">{$lang_plugin_theme_cache['cache_time_label']}</label></td>
		<td class="tableb"><input type="number" class="text" name="cachet" id="cachet" min="1" value="{$vals['cache_time']}" /></td>
	</tr>
	<tr>
		<td class="tableb" colspan="2" style="text-align:center"><br>
			<button value="{$lang_common['apply_changes']}" name="save" class="button" type="submit">
				{$submit_icon}{$lang_common['apply_changes']}
			</button>
		</td>
	</tr>
EOT;

	endtable();
}


if ($superCage->post->keyExists('save'))
	plg_theme_cache_config_save($superCage);

plg_theme_cache_config_form($superCage);

//EOF