<?php
defined('IN_COPPERMINE') or die('Not in Coppermine...');

function plugin_stc_cache ($buffer=null,$phase=null)
{
    global $CONFIG, $THEME_DIR, $superCage;
    static $cfnam;

	if ($buffer) {
		file_put_contents(dirname(dirname(__DIR__)).'/'.$cfnam, $buffer);
		return $buffer;
	}

	// only cache non logged in access
	if (USER_ID) return;
	// only cache if enabled in the theme
	if (!is_dir($THEME_DIR.'cache')) return;

	$pgs2cache = ['INDEX_PHP','THUMBNAILS_PHP'];	// pages to cache
    $pfx = false;
	foreach ($pgs2cache as $p2c) {
		if (defined($p2c)) {
			$pfx = substr($p2c,0,3);
		}
	}
	if (!$pfx) return;

	$vals = json_decode($CONFIG['plg_theme_cache_optvals'], true);

	$cfnam = $THEME_DIR.'cache/'.$pfx.md5($superCage->server->getEscaped('REQUEST_URI'));
	if (isset($cfnam) && file_exists($cfnam) && (filemtime($cfnam) > time() - $vals['cache_time'] * 3600)) {
		readfile($cfnam);
		echo '<!-- CACHED -->';
		exit;
	} else {
		ob_start('plugin_stc_cache');
	}
}

// Add a filter for the pageheader
$thisplugin->add_filter('theme_pageheader_params','plugin_stc_header');
function plugin_stc_header ($params)
{
	plugin_stc_cache();
	return $params;
}

// Add an install action
$thisplugin->add_action('plugin_install','plugin_stc_install');
function plugin_stc_install ()
{
	cpg_config_set('plg_theme_cache_optvals', json_encode(['cache_time'=>24]), true);
	return true;
}

//EOF