<?php
/**
 * Coppermine Photo Gallery
 *
 * Delete broken photos tool { ron4mac }
 *
 */

/* declare each item separately - not as an entire array() */
$lang['del_b'] = 'Delete broken photos that have no original and/or full image file (v1.0)';
$lang['del_b_what'] = 'What should be deleted';
$lang['del_b_thumb'] = 'Photos with no original and no full image file';
$lang['del_b_pic'] = 'Only photos with no original image file';
$lang['del_b_both'] = 'Both thumbnails and resized pictures';
$lang['del_b_full_normal_thumb'] = 'Everything: full-sized, resized and thumbs';
$lang['del_b_full_normal'] = 'Both resized and full sized (if an original copy is available)';
$lang['del_b_full'] = 'Just full sized (if an original copy is available)';
$lang['del_b_dryrun'] = 'Only perform a dry run (no actual deletion)';
$lang['del_b_dr_fini'] = 'Finished scanning for broken photos';
$lang['del_b_notitle'] = '-NO TITLE-';
$lang['del_b_dr_dele'] = 'Broken photo id %s';
$lang['del_b_dele'] = 'Deleted broken photo id %s';
$lang['del_b_dr_fini'] = 'Finished scanning for broken photos';
$lang['deleting'] = 'Deleting broken photos';
$lang['finished'] = 'Finished deleting broken photos';


class CPG_ToolDel_broken extends AdminTool
{
	protected $toolname = 'del_broken';
	public $progressive = true;

	public function describe ()
	{
		return $this->_('del_b');
	}

	public function procWords ()
	{
		return $this->_('deleting');
	}

	public function displayUI ()
	{
		return '
			<strong>' . $this->_('del_b_what') . ' (2):</strong><br>
			<input type="radio" name="deletetype" id="deletetype1" value="0" class="nobg" required /><label for="deletetype1" class="clickable_option">'.$this->_('del_b_thumb').'</label><br>
			<input type="radio" name="deletetype" id="deletetype2" value="1" class="nobg" /><label for="deletetype2" class="clickable_option">'.$this->_('del_b_pic').'</label><br>
			<input type="checkbox" name="dryrun" id="dryrun" class="nobg" checked /><label for="dryrun" class="">'.$this->_('del_b_dryrun').'</label>'
			;
	}

	public function total ()
	{
		$result = cpg_db_query("SELECT COUNT(pid) FROM {$this->config['TABLE_PICTURES']}{$this->albstr}");
		list($count) = $result->fetchRow(true);
		return $count;
	}

	public function process ()
	{
		$dry = $this->scp->keyExists('dryrun') ? true : false;

		if ($this->scp->keyExists('deletetype')) {
			$deletetype = $this->scp->getInt('deletetype');
		}

		if ($this->scp->keyExists('startpic')) {
			$startpic = $this->scp->getInt('startpic');
		} else {
			$startpic = 0;
		}

		$result = cpg_db_query("SELECT pid, title, filepath, filename FROM {$this->config['TABLE_PICTURES']}{$this->albstr} LIMIT {$startpic}, {$this->procnum}");
		$count = $result->numRows();
		$loopCounter = 0;

		while ($row = $result->fetchAssoc()) {

			if (is_image($row['filename'])) { // the file is an image --- start

				$loopCounter++;

				if ($loopCounter / 2 == floor($loopCounter / 2)) {
					$tablestyle = 'tableb tableb_alternate';
				} else {
					$tablestyle = 'tableb';
				}

				$image = $this->config['fullpath'] . $row['filepath'] . $row['filename'];
				$normal = $this->config['fullpath'] . $row['filepath'] . $this->config['normal_pfx'] . $row['filename'];
				$thumb = $this->config['fullpath'] . $row['filepath'] . $this->config['thumb_pfx'] . $row['filename'];
				$orig = $this->config['fullpath'] . $row['filepath'] . $this->config['orig_pfx'] . $row['filename'];

				if (file_exists($normal)) {
					$work_image = $normal;
				} elseif (file_exists($image)) {
					$work_image = $image;
				} else {
					$work_image = $orig;
				}

				if (!file_exists($work_image)|| ($deletetype==1 && !file_exists($orig))) {
					$pid = $row['pid'];
					if (!$dry) {
						if (file_exists($orig)) unlink($orig);
						if (file_exists($image)) unlink($image);
						if (file_exists($normal)) unlink($normal);
						if (file_exists($thumb)) unlink($thumb);
						cpg_db_query("DELETE FROM {$this->config['TABLE_PICTURES']} WHERE pid = $pid");
						cpg_db_query("DELETE FROM {$this->config['TABLE_COMMENTS']} WHERE pid = $pid");
						cpg_db_query("DELETE FROM {$this->config['TABLE_EXIF']} WHERE pid = $pid");
			
					//	$delete_counter++;
					}
					printf($this->_($dry ? 'del_b_dr_dele' : 'del_b_dele') .'<br>', $pid .' .. '. ($row['title'] ?: $this->_('del_b_notitle')));
					continue;
				}


			} else { // the file is an image --- end
			//	echo sprintf($this->_('no_image'), '<tt>' . $row['filepath'] . $row['filename'] . '</tt>').'<br>';
				$this->skpcnt++;
			}
		}
		$result->free();

		if ($count == $this->procnum) {
			$startpic += $this->procnum;
		} else {
			$this->done($this->_($dry ? 'del_b_dr_fini' : 'finished'));
			$startpic = -1;
		}
		return $startpic;
	}

}